/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.net.URI;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractTokenRequestLookupFunction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AbstractTokenRequestLookupFunctionTest {
    protected ProfileRequestContext prc;
    protected MessageContext msgCtx;
    protected OIDCAuthenticationResponseContext oidcCtx;
    protected MockOKLookupFunction mock = new MockOKLookupFunction();

    @BeforeMethod
    protected void setUpCtxs() throws Exception {
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        this.msgCtx = new MessageContext();
        this.prc.setInboundMessageContext(this.msgCtx);
        TokenRequest req = new TokenRequest(new URI("http://example.com"), (AuthorizationGrant)new RefreshTokenGrant(new RefreshToken()), null);
        this.msgCtx.setMessage((Object)req);
    }

    @Test
    public void testOK() {
        Assert.assertEquals((Object)"OK", (Object)this.mock.apply(this.prc));
    }

    @Test
    public void testNoInboundCtxts() {
        Assert.assertNull((Object)this.mock.apply(null));
        this.prc.setInboundMessageContext(null);
        Assert.assertNull((Object)this.mock.apply(this.prc));
        this.prc.setInboundMessageContext(this.msgCtx);
        this.msgCtx.setMessage(null);
        Assert.assertNull((Object)this.mock.apply(this.prc));
    }

    class MockOKLookupFunction
    extends AbstractTokenRequestLookupFunction<Object> {
        MockOKLookupFunction() {
        }

        Object doLookup(TokenRequest req) {
            return req != null ? new String("OK") : new String("NOK");
        }
    }
}

