/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.List;
import net.minidev.json.JSONArray;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenDeliveryClaimsClaimsSet;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.annotations.BeforeMethod;

public class BaseTokenRequestLookupFunctionTest {
    protected ProfileRequestContext prc;
    protected MessageContext msgCtx;
    protected OIDCAuthenticationResponseContext oidcCtx;
    protected ClientID cliendID = new ClientID();
    protected String issuer = "issuer";
    protected String userPrin = "userPrin";
    protected String subject = "subject";
    protected ACR acr = new ACR("0");
    protected Instant iat = Instant.now();
    protected Instant exp = Instant.now().plusSeconds(1L);
    protected Nonce nonce = new Nonce();
    protected Instant authTime = Instant.now();
    protected URI redirectUri;
    protected Scope scope = new Scope();
    protected String idpSessionId = "idpSessionId";
    protected OIDCClaimsRequest claimsRequest;
    protected ClaimsSet tokenDeliveryClaims = new TokenDeliveryClaimsClaimsSet();
    protected ClaimsSet tokenToIdTokenDeliveryClaims = new TokenDeliveryClaimsClaimsSet();
    protected ClaimsSet tokenToUserInfoTokenDeliveryClaims = new TokenDeliveryClaimsClaimsSet();
    protected JSONArray consentedClaims = new JSONArray();

    BaseTokenRequestLookupFunctionTest() {
        try {
            this.redirectUri = new URI("http://example.com");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        ClaimsSetRequest idTokenClaimsSet = new ClaimsSetRequest().add("email");
        this.claimsRequest = new OIDCClaimsRequest().withIDTokenClaimsRequest(idTokenClaimsSet);
        this.tokenDeliveryClaims.setClaim("tokenDelivery", (Object)"value");
        this.tokenToIdTokenDeliveryClaims.setClaim("tokenToIdtokenDelivery", (Object)"value");
        this.tokenToUserInfoTokenDeliveryClaims.setClaim("tokenToUserInfotokenDeliveryClaim", (Object)"value");
        this.consentedClaims.add((Object)"consentedClaim");
    }

    @BeforeMethod
    protected void setUpCtxs() throws Exception {
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        this.prc.setOutboundMessageContext(new MessageContext());
        this.oidcCtx = new OIDCAuthenticationResponseContext();
        this.prc.getOutboundMessageContext().addSubcontext((BaseContext)this.oidcCtx);
        this.oidcCtx.setTokenClaimsSet(new AuthorizeCodeClaimsSet.Builder((IdentifierGenerationStrategy)new SecureRandomIdentifierGenerationStrategy(), this.cliendID, this.issuer, this.userPrin, this.subject, this.iat, this.exp, this.authTime, this.redirectUri, this.scope).setACR(this.acr).setNonce(this.nonce).setClaims(this.claimsRequest).setDlClaims(this.tokenDeliveryClaims).setDlClaimsID(this.tokenToIdTokenDeliveryClaims).setDlClaimsUI(this.tokenToUserInfoTokenDeliveryClaims).setConsentedClaims((List)this.consentedClaims).build());
    }
}

