/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import java.time.Instant;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultAuthTimeLookupFunction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultAuthTimeLookupFunctionTest {
    private DefaultAuthTimeLookupFunction lookup;
    private ProfileRequestContext prc;
    private Instant instant = Instant.now();
    private AuthenticationResult result;
    private AuthenticationContext authCtx;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.lookup = new DefaultAuthTimeLookupFunction();
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        this.authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class, true);
        this.result = new AuthenticationResult("id", new Subject());
        this.result.setAuthenticationInstant(this.instant);
        this.authCtx.setAuthenticationResult(this.result);
    }

    @Test
    public void testSuccess() {
        Assert.assertEquals((Object)this.instant, (Object)this.lookup.apply(this.prc));
    }

    @Test
    public void testNoCtxts() {
        Assert.assertNull((Object)this.lookup.apply(null));
        this.authCtx.setAuthenticationResult(null);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
        this.prc.removeSubcontext(AuthenticationContext.class);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
    }
}

