/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.net.URI;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.BaseDefaultRequestLookupFunctionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestStateLookupFunction;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultRequestStateLookupFunctionTest
extends BaseDefaultRequestLookupFunctionTest {
    private DefaultRequestStateLookupFunction lookup;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.lookup = new DefaultRequestStateLookupFunction();
    }

    @Test
    public void testSuccessNoReqObject() {
        String stateReqParam = "requestparameterstate";
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).loginHint("hint").state(new State(stateReqParam)).build();
        this.msgCtx.setMessage((Object)req);
        Assert.assertEquals((String)stateReqParam, (String)((State)this.lookup.apply(this.prc)).getValue());
    }

    @Test
    public void testSuccessReqObject() {
        String stateReqParam = "requestparameterstate";
        String stateReqObj = "requestobjectstate";
        JWTClaimsSet ro = new JWTClaimsSet.Builder().claim("state", (Object)stateReqObj).build();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).loginHint("hint").state(new State(stateReqParam)).requestObject((JWT)new PlainJWT(ro)).build();
        this.msgCtx.setMessage((Object)req);
        this.oidcCtx.setRequestObject(req.getRequestObject());
        Assert.assertEquals((String)stateReqObj, (String)((State)this.lookup.apply(this.prc)).getValue());
    }
}

