/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.BaseDefaultRequestLookupFunctionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestedAcrLookupFunction;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultRequestedAcrLookupFunctionTest
extends BaseDefaultRequestLookupFunctionTest {
    private DefaultRequestedAcrLookupFunction lookup;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.lookup = new DefaultRequestedAcrLookupFunction();
    }

    @Test
    public void testSuccessNoReqObject() {
        ArrayList<ACR> acrValues = new ArrayList<ACR>();
        acrValues.add(new ACR("1"));
        acrValues.add(new ACR("2"));
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).acrValues(acrValues).state(new State()).build();
        this.msgCtx.setMessage((Object)req);
        Assert.assertTrue((boolean)((List)this.lookup.apply(this.prc)).contains(new ACR("1")));
        Assert.assertTrue((boolean)((List)this.lookup.apply(this.prc)).contains(new ACR("2")));
        Assert.assertEquals((int)2, (int)((List)this.lookup.apply(this.prc)).size());
    }

    @Test
    public void testSuccessReqObject() {
        ArrayList<ACR> acrValues = new ArrayList<ACR>();
        acrValues.add(new ACR("1"));
        JWTClaimsSet ro = new JWTClaimsSet.Builder().claim("acr_values", (Object)"1 2").build();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).acrValues(acrValues).state(new State()).requestObject((JWT)new PlainJWT(ro)).build();
        this.msgCtx.setMessage((Object)req);
        this.oidcCtx.setRequestObject(req.getRequestObject());
        Assert.assertTrue((boolean)((List)this.lookup.apply(this.prc)).contains(new ACR("1")));
        Assert.assertTrue((boolean)((List)this.lookup.apply(this.prc)).contains(new ACR("2")));
        Assert.assertEquals((int)2, (int)((List)this.lookup.apply(this.prc)).size());
    }
}

