/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.net.URI;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.BaseDefaultRequestLookupFunctionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestedPromptLookupFunction;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultRequestedPromptLookupFunctionTest
extends BaseDefaultRequestLookupFunctionTest {
    private DefaultRequestedPromptLookupFunction lookup;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.lookup = new DefaultRequestedPromptLookupFunction();
    }

    @Test
    public void testSuccessNoReqObject() {
        Prompt parameterPrompt = new Prompt();
        parameterPrompt.add((Object)Prompt.Type.CONSENT);
        parameterPrompt.add((Object)Prompt.Type.LOGIN);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).prompt(parameterPrompt).state(new State()).build();
        this.msgCtx.setMessage((Object)req);
        Assert.assertTrue((boolean)((Prompt)this.lookup.apply(this.prc)).contains((Object)Prompt.Type.CONSENT));
        Assert.assertTrue((boolean)((Prompt)this.lookup.apply(this.prc)).contains((Object)Prompt.Type.LOGIN));
        Assert.assertEquals((int)2, (int)((Prompt)this.lookup.apply(this.prc)).size());
    }

    @Test
    public void testSuccessReqObject() {
        Prompt parameterPrompt = new Prompt();
        parameterPrompt.add((Object)Prompt.Type.CONSENT);
        JWTClaimsSet ro = new JWTClaimsSet.Builder().claim("prompt", (Object)"login consent").build();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).prompt(parameterPrompt).state(new State()).requestObject((JWT)new PlainJWT(ro)).build();
        this.msgCtx.setMessage((Object)req);
        this.oidcCtx.setRequestObject(req.getRequestObject());
        Assert.assertTrue((boolean)((Prompt)this.lookup.apply(this.prc)).contains((Object)Prompt.Type.CONSENT));
        Assert.assertTrue((boolean)((Prompt)this.lookup.apply(this.prc)).contains((Object)Prompt.Type.LOGIN));
        Assert.assertEquals((int)2, (int)((Prompt)this.lookup.apply(this.prc)).size());
    }
}

