/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.Date;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCMetadataContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultUserInfoSigningAlgLookupFunction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultUserInfoSigningAlgLookupFunctionTest {
    private DefaultUserInfoSigningAlgLookupFunction lookup;
    private ProfileRequestContext prc;
    private OIDCMetadataContext ctx;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.lookup = new DefaultUserInfoSigningAlgLookupFunction();
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        this.prc.setInboundMessageContext(new MessageContext());
        this.ctx = (OIDCMetadataContext)this.prc.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class, true);
        this.ctx.setClientInformation(new OIDCClientInformation(new ClientID("id"), new Date(), new OIDCClientMetadata(), new Secret()));
        this.ctx.getClientInformation().getOIDCMetadata().setUserInfoJWSAlg(JWSAlgorithm.ES256);
    }

    @Test
    public void testSuccess() {
        Assert.assertEquals((Object)JWSAlgorithm.ES256, (Object)this.lookup.apply(this.prc));
    }

    @Test
    public void testNoInput() {
        Assert.assertNull((Object)this.lookup.apply(null));
        this.ctx.setClientInformation(null);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
        this.prc.getInboundMessageContext().removeSubcontext(OIDCMetadataContext.class);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
        this.prc.setInboundMessageContext(null);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
    }
}

