/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import java.util.HashMap;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.ProfileResponderIdLookupFunction;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.mockito.Mockito;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProfileResponderIdLookupFunctionTest {
    private ProfileResponderIdLookupFunction lookup;
    private ProfileRequestContext prc;

    @BeforeMethod
    protected void setUp() throws Exception {
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        this.lookup = new ProfileResponderIdLookupFunction();
        this.lookup.setId("1");
        this.lookup.setDefaultResponder("defaultvalue");
        HashMap<ProfileConfiguration, String> resp = new HashMap<ProfileConfiguration, String>();
        this.lookup.initialize();
        ProfileConfiguration conf1 = (ProfileConfiguration)Mockito.mock(ProfileConfiguration.class);
        Mockito.when((Object)conf1.getId()).thenReturn((Object)"id1");
        resp.put(conf1, "value1");
        ProfileConfiguration conf2 = (ProfileConfiguration)Mockito.mock(ProfileConfiguration.class);
        Mockito.when((Object)conf2.getId()).thenReturn((Object)"id2");
        resp.put(conf2, "value2");
        this.lookup.setProfileResponders(resp);
    }

    @Test
    public void testSuccess() throws ComponentInitializationException {
        this.prc.setProfileId("unknown");
        Assert.assertEquals((String)this.lookup.apply(this.prc), (String)"defaultvalue");
        this.prc.setProfileId("id1");
        Assert.assertEquals((String)this.lookup.apply(this.prc), (String)"value1");
        this.prc.setProfileId("id2");
        Assert.assertEquals((String)this.lookup.apply(this.prc), (String)"value2");
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testInitialization() throws ComponentInitializationException {
        this.lookup = new ProfileResponderIdLookupFunction();
        this.lookup.setId("1");
        this.lookup.initialize();
    }
}

