/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCMetadataContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.SectorIdentifierLookupFunction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SectorIdentifierLookupFunctionTest {
    private SectorIdentifierLookupFunction lookup;
    private ProfileRequestContext prc;
    private MessageContext msgCtx;
    private OIDCMetadataContext ctx;
    private URI sector;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.sector = new URI("https://example.org/uri");
        this.lookup = new SectorIdentifierLookupFunction();
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        this.msgCtx = new MessageContext();
        this.prc.setInboundMessageContext(this.msgCtx);
        this.ctx = new OIDCMetadataContext();
        OIDCClientMetadata metadata = new OIDCClientMetadata();
        OIDCClientInformation information = new OIDCClientInformation(new ClientID(), new Date(), metadata, new Secret());
        this.ctx.setClientInformation(information);
        this.msgCtx.addSubcontext((BaseContext)this.ctx);
    }

    @Test
    public void testSuccessSectorID() {
        this.ctx.getClientInformation().getOIDCMetadata().setSectorIDURI(this.sector);
        String locatedSector = this.lookup.apply(this.prc);
        Assert.assertEquals((String)locatedSector, (String)this.sector.getHost());
    }

    @Test
    public void testSuccessRedirectURI() {
        this.ctx.getClientInformation().getOIDCMetadata().setRedirectionURI(this.sector);
        String locatedSector = this.lookup.apply(this.prc);
        Assert.assertEquals((String)locatedSector, (String)this.sector.getHost());
    }

    @Test
    public void testSuccessRedirectURIs() {
        HashSet<URI> redirectURIs = new HashSet<URI>();
        redirectURIs.add(this.sector);
        this.ctx.getClientInformation().getOIDCMetadata().setRedirectionURIs(redirectURIs);
        String locatedSector = this.lookup.apply(this.prc);
        Assert.assertEquals((String)locatedSector, (String)this.sector.getHost());
    }

    @Test
    public void testSuccessMultipleRedirectURIs() throws URISyntaxException {
        HashSet<URI> redirectURIs = new HashSet<URI>();
        redirectURIs.add(this.sector);
        redirectURIs.add(new URI("https://example.org/uri2"));
        redirectURIs.add(new URI("https://example.org/uri3"));
        this.ctx.getClientInformation().getOIDCMetadata().setRedirectionURIs(redirectURIs);
        String locatedSector = this.lookup.apply(this.prc);
        Assert.assertEquals((String)locatedSector, (String)this.sector.getHost());
    }

    @Test
    public void testFailRedirectURIs() throws URISyntaxException {
        HashSet<URI> redirectURIs = new HashSet<URI>();
        redirectURIs.add(this.sector);
        redirectURIs.add(new URI("https://example2.org"));
        this.ctx.getClientInformation().getOIDCMetadata().setRedirectionURIs(redirectURIs);
        String locatedSector = this.lookup.apply(this.prc);
        Assert.assertNull((Object)locatedSector);
    }

    @Test
    public void testFailNoURIs() throws URISyntaxException {
        String locatedSector = this.lookup.apply(this.prc);
        Assert.assertNull((Object)locatedSector);
    }

    @Test
    public void testFailNoCtx() throws URISyntaxException {
        this.msgCtx.removeSubcontext(OIDCMetadataContext.class);
        String locatedSector = this.lookup.apply(this.prc);
        Assert.assertNull((Object)locatedSector);
    }

    @Test
    public void testFailNoClientInformation() throws URISyntaxException {
        this.ctx.setClientInformation(null);
        String locatedSector = this.lookup.apply(this.prc);
        Assert.assertNull((Object)locatedSector);
    }
}

