/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.TokenRequestRedirectURILookupFunction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TokenRequestRedirectURILookupFunctionTest {
    private TokenRequestRedirectURILookupFunction lookup;
    protected ProfileRequestContext prc;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.lookup = new TokenRequestRedirectURILookupFunction();
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        this.prc.setInboundMessageContext(new MessageContext());
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("grant_type", Arrays.asList("authorization_code"));
        params.put("code", Arrays.asList("xyz_code_abc"));
        params.put("redirect_uri", Arrays.asList("http://example.com/redirect"));
        TokenRequest req = new TokenRequest(new URI("http://example.com"), new ClientID("clientId"), (AuthorizationGrant)AuthorizationCodeGrant.parse(params));
        this.prc.getInboundMessageContext().setMessage((Object)req);
    }

    @Test
    public void testSuccess() throws URISyntaxException {
        Assert.assertEquals((Object)new URI("http://example.com/redirect"), (Object)this.lookup.apply(this.prc));
    }

    @Test
    public void testNoUri() throws URISyntaxException, ParseException {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("grant_type", Arrays.asList("authorization_code"));
        params.put("code", Arrays.asList("xyz_code_abc"));
        TokenRequest req = new TokenRequest(new URI("http://example.com"), new ClientID("clientId"), (AuthorizationGrant)AuthorizationCodeGrant.parse(params));
        this.prc.getInboundMessageContext().setMessage((Object)req);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
    }
}

