/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.UserInfoResponseClaimsSetLookupFunction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class UserInfoResponseClaimsSetLookupFunctionTest {
    private UserInfoResponseClaimsSetLookupFunction lookup;
    private ProfileRequestContext prc;
    private OIDCAuthenticationResponseContext oidcCtx;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.lookup = new UserInfoResponseClaimsSetLookupFunction();
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        this.prc.setOutboundMessageContext(new MessageContext());
        this.oidcCtx = new OIDCAuthenticationResponseContext();
        this.prc.getOutboundMessageContext().addSubcontext((BaseContext)this.oidcCtx);
        Subject sub = new Subject("sub");
        UserInfo info = new UserInfo(sub);
        this.oidcCtx.setUserInfo(info);
    }

    @Test
    public void testSuccess() {
        Assert.assertEquals((String)"sub", (String)((String)this.lookup.apply(this.prc).getClaim("sub")));
    }

    @Test
    public void testNoInput() {
        Assert.assertNull((Object)this.lookup.apply(null));
        this.oidcCtx.setUserInfo(null);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
        this.prc.getOutboundMessageContext().removeSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
        this.prc.setOutboundMessageContext(null);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
    }
}

