/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.token.support;

import java.text.ParseException;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.testing.BaseTokenClaimsSetTest;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AuthorizeCodeClaimsSetTest
extends BaseTokenClaimsSetTest {
    private AuthorizeCodeClaimsSet acClaimsSet;

    protected void init() {
        this.acClaimsSet = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder((IdentifierGenerationStrategy)new SecureRandomIdentifierGenerationStrategy(), this.clientID, this.issuer, this.userPrincipal, this.subject, this.iat, this.exp, this.authTime, this.redirectURI, this.scope).setACR(this.acr).build();
    }

    @Test
    public void testSerialization() throws ParseException, DataSealerException {
        this.init();
        AuthorizeCodeClaimsSet acClaimsSet2 = AuthorizeCodeClaimsSet.parse((String)this.acClaimsSet.serialize());
        Assert.assertEquals((String)acClaimsSet2.getACR(), (String)this.acr.getValue());
        AuthorizeCodeClaimsSet acClaimsSet3 = AuthorizeCodeClaimsSet.parse((String)acClaimsSet2.serialize(this.sealer), (DataSealer)this.sealer);
        Assert.assertEquals((String)acClaimsSet3.getACR(), (String)this.acr.getValue());
    }

    @Test(expectedExceptions={ParseException.class})
    public void testSerializationWrongType() throws ParseException {
        AccessTokenClaimsSet accessnClaimsSet = new AccessTokenClaimsSet.Builder((IdentifierGenerationStrategy)new SecureRandomIdentifierGenerationStrategy(), this.clientID, this.issuer, this.userPrincipal, this.subject, this.iat, this.exp, this.authTime, this.redirectURI, this.scope).build();
        this.acClaimsSet = AuthorizeCodeClaimsSet.parse((String)accessnClaimsSet.serialize());
    }
}

