/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.token.support;

import java.text.ParseException;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.testing.BaseTokenClaimsSetTest;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RefreshTokenClaimsSetTest
extends BaseTokenClaimsSetTest {
    private RefreshTokenClaimsSet rfClaimsSet;

    protected void init() {
        AuthorizeCodeClaimsSet acClaimsSet = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder((IdentifierGenerationStrategy)new SecureRandomIdentifierGenerationStrategy(), this.clientID, this.issuer, this.userPrincipal, this.subject, this.iat, this.exp, this.authTime, this.redirectURI, this.scope).setACR(this.acr).build();
        this.rfClaimsSet = new RefreshTokenClaimsSet((TokenClaimsSet)acClaimsSet, this.iat, this.exp);
    }

    @Test
    public void testSerialization() throws ParseException, DataSealerException {
        this.init();
        RefreshTokenClaimsSet rfClaimsSet2 = RefreshTokenClaimsSet.parse((String)this.rfClaimsSet.serialize());
        Assert.assertEquals((String)rfClaimsSet2.getACR(), (String)this.acr.getValue());
        RefreshTokenClaimsSet rfClaimsSet3 = RefreshTokenClaimsSet.parse((String)rfClaimsSet2.serialize(this.sealer), (DataSealer)this.sealer);
        Assert.assertEquals((String)rfClaimsSet3.getACR(), (String)this.acr.getValue());
    }

    @Test(expectedExceptions={ParseException.class})
    public void testSerializationWrongType() throws ParseException {
        AuthorizeCodeClaimsSet accessnClaimsSet = new AuthorizeCodeClaimsSet.Builder((IdentifierGenerationStrategy)new SecureRandomIdentifierGenerationStrategy(), this.clientID, this.issuer, this.userPrincipal, this.subject, this.iat, this.exp, this.authTime, this.redirectURI, this.scope).build();
        this.rfClaimsSet = RefreshTokenClaimsSet.parse((String)accessnClaimsSet.serialize());
    }
}

