/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.token.support;

import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Set;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.testing.BaseTokenClaimsSetTest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TokenClaimsSetTest
extends BaseTokenClaimsSetTest {
    private TokenClaimsSet tokenClaimsSet;
    private String tokenType = "myType";
    private String tokenID = "1";

    protected void init() {
        this.tokenClaimsSet = new TokenClaimsSet(this.tokenType, this.tokenID, this.clientID, this.issuer, this.userPrincipal, this.subject, this.acr, this.iat, this.exp, this.nonce, this.authTime, this.redirectURI, this.scope, this.claims, this.dlClaims, this.dlClaimsID, this.dlClaimsUI, (List)this.consentedClaims, this.codeChallenge, this.consentEnabled);
    }

    @Test
    public void testGetters() {
        this.init();
        Assert.assertEquals((String)this.tokenClaimsSet.getACR(), (String)this.acr.getValue());
        Assert.assertEquals((String)this.tokenClaimsSet.getID(), (String)this.tokenID);
        Assert.assertEquals((String)this.tokenClaimsSet.getPrincipal(), (String)this.userPrincipal);
        Assert.assertEquals((boolean)this.tokenClaimsSet.isExpired(), (boolean)false);
        Assert.assertEquals((Object)this.tokenClaimsSet.getAuthenticationTime(), (Object)this.authTime.truncatedTo(ChronoUnit.MILLIS));
        Assert.assertTrue((boolean)this.tokenClaimsSet.getClaimsRequest().getIDTokenClaimsRequest().getClaimNames(false).contains("email"));
        Assert.assertEquals((Object)this.tokenClaimsSet.getDeliveryClaims().getClaim("tokenDelivery"), (Object)"value");
        Assert.assertEquals((Object)this.tokenClaimsSet.getIDTokenDeliveryClaims().getClaim("tokenToIdtokenDeliveryClaim"), (Object)"value");
        Assert.assertEquals((Object)this.tokenClaimsSet.getUserinfoDeliveryClaims().getClaim("tokenToUserInfotokenDeliveryClaim"), (Object)"value");
        Assert.assertEquals((Object)this.tokenClaimsSet.getClientID(), (Object)this.clientID);
        Assert.assertTrue((boolean)this.tokenClaimsSet.getConsentedClaims().contains("consentedClaim"));
        Assert.assertEquals((Object)this.tokenClaimsSet.getExp(), (Object)this.exp.truncatedTo(ChronoUnit.MILLIS));
        Assert.assertEquals((Object)this.tokenClaimsSet.getNonce(), (Object)this.nonce);
        Assert.assertEquals((Object)this.tokenClaimsSet.getRedirectURI(), (Object)this.redirectURI);
        Assert.assertEquals((Set)this.tokenClaimsSet.getScope(), (Set)this.scope);
        Assert.assertEquals((String)this.tokenClaimsSet.getCodeChallenge(), (String)this.codeChallenge);
        Assert.assertEquals((boolean)this.tokenClaimsSet.isConsentEnabled(), (boolean)this.consentEnabled);
    }

    @Test
    public void testNullGetters() {
        this.tokenClaimsSet = new TokenClaimsSet(this.tokenType, this.tokenID, this.clientID, this.issuer, this.userPrincipal, this.subject, null, this.iat, this.exp, null, this.authTime, this.redirectURI, this.scope, null, null, null, null, null, null, false);
        Assert.assertNull((Object)this.tokenClaimsSet.getACR());
        Assert.assertNull((Object)this.tokenClaimsSet.getClaimsRequest());
        Assert.assertNull((Object)this.tokenClaimsSet.getDeliveryClaims());
        Assert.assertNull((Object)this.tokenClaimsSet.getIDTokenDeliveryClaims());
        Assert.assertNull((Object)this.tokenClaimsSet.getUserinfoDeliveryClaims());
        Assert.assertNull((Object)this.tokenClaimsSet.getConsentedClaims());
        Assert.assertNull((Object)this.tokenClaimsSet.getNonce());
        Assert.assertFalse((boolean)this.tokenClaimsSet.isConsentEnabled());
    }
}

