/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import net.shibboleth.idp.plugin.oidc.op.messaging.JSONErrorResponse;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JSONErrorResponseTest {
    private JSONErrorResponse response;
    ErrorObject content;

    @BeforeMethod
    public void init() throws ParseException {
        this.content = new ErrorObject("errorCode", "errorDescription", 400);
    }

    @Test
    public void testSuccess() throws ParseException {
        this.response = new JSONErrorResponse(this.content, "no-store", "no-cache");
        HTTPResponse httpResponse = this.response.toHTTPResponse();
        Assert.assertEquals((int)400, (int)httpResponse.getStatusCode());
        Assert.assertEquals((String)"application/json; charset=UTF-8", (String)httpResponse.getEntityContentType().toString());
        Assert.assertEquals((String)"no-store", (String)httpResponse.getCacheControl());
        Assert.assertEquals((String)"no-cache", (String)httpResponse.getPragma());
        JSONObject parsedContent = (JSONObject)new JSONParser(-1).parse(httpResponse.getContent());
        Assert.assertEquals((Object)"errorCode", (Object)parsedContent.get((Object)"error"));
        Assert.assertEquals((Object)"errorDescription", (Object)parsedContent.get((Object)"error_description"));
    }

    @Test
    public void testSuccess2() throws ParseException {
        this.response = new JSONErrorResponse(this.content);
        HTTPResponse httpResponse = this.response.toHTTPResponse();
        Assert.assertEquals((int)400, (int)httpResponse.getStatusCode());
        Assert.assertEquals((String)"application/json; charset=UTF-8", (String)httpResponse.getEntityContentType().toString());
        Assert.assertNull((Object)httpResponse.getCacheControl());
        Assert.assertNull((Object)httpResponse.getPragma());
        JSONObject parsedContent = (JSONObject)new JSONParser(-1).parse(httpResponse.getContent());
        Assert.assertEquals((Object)"errorCode", (Object)parsedContent.get((Object)"error"));
        Assert.assertEquals((Object)"errorDescription", (Object)parsedContent.get((Object)"error_description"));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testFail() throws ParseException {
        this.response = new JSONErrorResponse(null);
    }
}

