/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging;

import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import net.shibboleth.idp.plugin.oidc.op.messaging.JSONSuccessResponse;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JSONSuccessResponseTest {
    JSONSuccessResponse response;
    JSONObject content;

    @BeforeMethod
    public void init() throws ParseException {
        this.content = new JSONObject();
        this.content.put((Object)"field1", (Object)"value1");
        this.content.put((Object)"field2", (Object)"value2");
    }

    @Test
    public void testSuccess() throws ParseException {
        this.response = new JSONSuccessResponse(this.content, "no-store", "no-cache");
        HTTPResponse httpResponse = this.response.toHTTPResponse();
        Assert.assertEquals((int)200, (int)httpResponse.getStatusCode());
        Assert.assertEquals((String)"application/json; charset=UTF-8", (String)httpResponse.getEntityContentType().toString());
        Assert.assertEquals((String)"no-store", (String)httpResponse.getCacheControl());
        Assert.assertEquals((String)"no-cache", (String)httpResponse.getPragma());
        JSONObject parsedContent = (JSONObject)new JSONParser(-1).parse(httpResponse.getContent());
        Assert.assertEquals((Object)this.content.get((Object)"field1"), (Object)parsedContent.get((Object)"field1"));
        Assert.assertEquals((Object)this.content.get((Object)"field2"), (Object)parsedContent.get((Object)"field2"));
    }

    @Test
    public void testSuccess2() throws ParseException {
        this.response = new JSONSuccessResponse(this.content);
        HTTPResponse httpResponse = this.response.toHTTPResponse();
        Assert.assertEquals((int)200, (int)httpResponse.getStatusCode());
        Assert.assertEquals((String)"application/json; charset=UTF-8", (String)httpResponse.getEntityContentType().toString());
        Assert.assertNull((Object)httpResponse.getCacheControl());
        Assert.assertNull((Object)httpResponse.getPragma());
        JSONObject parsedContent = (JSONObject)new JSONParser(-1).parse(httpResponse.getContent());
        Assert.assertEquals((Object)this.content.get((Object)"field1"), (Object)parsedContent.get((Object)"field1"));
        Assert.assertEquals((Object)this.content.get((Object)"field2"), (Object)parsedContent.get((Object)"field2"));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testFail() throws ParseException {
        this.response = new JSONSuccessResponse(null);
    }
}

