/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.net.URI;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AbstractAuthenticationRequestLookupFunctionTest {
    protected ProfileRequestContext prc;
    protected MessageContext msgCtx;
    protected OIDCAuthenticationResponseContext oidcCtx;
    protected MockOKLookupFunction mock = new MockOKLookupFunction();

    @BeforeMethod
    protected void setUpCtxs() throws Exception {
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        this.msgCtx = new MessageContext();
        this.prc.setInboundMessageContext(this.msgCtx);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).state(new State()).build();
        this.msgCtx.setMessage((Object)req);
        this.prc.setOutboundMessageContext(new MessageContext());
        this.oidcCtx = new OIDCAuthenticationResponseContext();
        this.prc.getOutboundMessageContext().addSubcontext((BaseContext)this.oidcCtx);
    }

    @Test
    public void testOK() {
        Assert.assertEquals((String)"OK", (String)((String)this.mock.apply(this.prc)));
    }

    @Test
    public void testNoInboundCtxts() {
        Assert.assertNull((Object)this.mock.apply(null));
        this.prc.setInboundMessageContext(null);
        Assert.assertNull((Object)this.mock.apply(this.prc));
        this.prc.setInboundMessageContext(this.msgCtx);
        this.msgCtx.setMessage(null);
        Assert.assertNull((Object)this.mock.apply(this.prc));
    }

    class MockOKLookupFunction
    extends AbstractAuthenticationRequestLookupFunction<String> {
        MockOKLookupFunction() {
        }

        protected String doLookup(AuthenticationRequest req) {
            return req != null ? new String("OK") : new String("NOK");
        }
    }
}

