/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.net.URI;
import java.time.Instant;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractTokenClaimsLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AbstractTokenClaimsLookupFunctionTest {
    protected ProfileRequestContext prc;
    protected OIDCAuthenticationResponseContext oidcCtx;
    protected MockSubLookupFunction mock = new MockSubLookupFunction();

    @BeforeMethod
    protected void setUpCtxs() throws Exception {
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        this.prc.setOutboundMessageContext(new MessageContext());
        this.oidcCtx = new OIDCAuthenticationResponseContext();
        this.prc.getOutboundMessageContext().addSubcontext((BaseContext)this.oidcCtx);
        this.oidcCtx.setAuthorizationGrantClaimsSet(new AccessTokenClaimsSet.Builder().setJWTID((IdentifierGenerationStrategy)new SecureRandomIdentifierGenerationStrategy()).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now().plusSeconds(1L)).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).build());
    }

    @Test
    public void testSubjectSuccess() {
        Assert.assertEquals((Object)"subject", (Object)this.mock.apply(this.prc));
    }

    @Test
    public void testNoCtxts() {
        Assert.assertNull((Object)this.mock.apply(null));
        this.prc.setOutboundMessageContext(null);
        Assert.assertNull((Object)this.mock.apply(this.prc));
        this.prc.setOutboundMessageContext(new MessageContext());
        Assert.assertNull((Object)this.mock.apply(this.prc));
        this.prc.getOutboundMessageContext().addSubcontext((BaseContext)new OIDCAuthenticationResponseContext());
        Assert.assertNull((Object)this.mock.apply(this.prc));
    }

    class MockSubLookupFunction
    extends AbstractTokenClaimsLookupFunction<Object> {
        MockSubLookupFunction() {
        }

        Object doLookup(TokenClaimsSet tokenClaims) {
            return tokenClaims.getClaimsSet().getClaim("sub");
        }
    }
}

