/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultOIDCMetadataContextLookupFunctionTest {
    private DefaultOIDCMetadataContextLookupFunction lookup;
    private ProfileRequestContext prc;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.lookup = new DefaultOIDCMetadataContextLookupFunction();
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        MessageContext msgCtx = new MessageContext();
        this.prc.setInboundMessageContext(msgCtx);
        msgCtx.addSubcontext((BaseContext)new OIDCMetadataContext());
    }

    @Test
    public void testSuccess() {
        OIDCMetadataContext ctx = this.lookup.apply(this.prc);
        Assert.assertNotNull((Object)ctx);
    }

    @Test
    public void testNoMetadataCtx() {
        this.prc.getInboundMessageContext().removeSubcontext(OIDCMetadataContext.class);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
    }

    @Test
    public void testNoMessageCtx() {
        this.prc.setInboundMessageContext(null);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
    }

    @Test
    public void testNoPrc() {
        Assert.assertNull((Object)this.lookup.apply(null));
    }
}

