/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.net.URI;
import java.time.Duration;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.BaseDefaultRequestLookupFunctionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestMaxAgeLookupFunction;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultRequestMaxAgeFunctionTest
extends BaseDefaultRequestLookupFunctionTest {
    private DefaultRequestMaxAgeLookupFunction lookup;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.lookup = new DefaultRequestMaxAgeLookupFunction();
    }

    @Test
    public void testSuccessNoMaxAge() {
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).state(new State()).build();
        this.msgCtx.setMessage((Object)req);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
    }

    @Test
    public void testSuccessMaxAgeRequestParameter() {
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).maxAge(300).state(new State()).build();
        this.msgCtx.setMessage((Object)req);
        Assert.assertEquals((Object)Duration.ofSeconds(300L), (Object)this.lookup.apply(this.prc));
    }

    @Test
    public void testSuccessMaxAgeRequestObject() {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().claim("max_age", (Object)600).build();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).maxAge(300).requestObject((JWT)new PlainJWT(ro)).state(new State()).build();
        this.msgCtx.setMessage((Object)req);
        this.oidcCtx.setRequestObject(req.getRequestObject());
        Assert.assertEquals((Object)Duration.ofSeconds(600L), (Object)this.lookup.apply(this.prc));
    }
}

