/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.net.URI;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.BaseDefaultRequestLookupFunctionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestRedirectURILookupFunction;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultRequestRedirectURILookupFunctionTest
extends BaseDefaultRequestLookupFunctionTest {
    private DefaultRequestRedirectURILookupFunction lookup;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.lookup = new DefaultRequestRedirectURILookupFunction();
    }

    @Test
    public void testSuccessNoReqObject() {
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).state(new State()).build();
        this.msgCtx.setMessage((Object)req);
        Assert.assertEquals((String)"https://example.com/callback", (String)((URI)this.lookup.apply(this.prc)).toString());
    }

    @Test
    public void testSuccessReqObject() {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().claim("redirect_uri", (Object)"https://example.com/callback/reqobj").build();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).state(new State()).requestObject((JWT)new PlainJWT(ro)).build();
        this.msgCtx.setMessage((Object)req);
        this.oidcCtx.setRequestObject(req.getRequestObject());
        Assert.assertEquals((String)"https://example.com/callback/reqobj", (String)((URI)this.lookup.apply(this.prc)).toString());
    }
}

