/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import java.net.URI;
import java.text.ParseException;
import java.util.Map;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.BaseDefaultRequestLookupFunctionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestedClaimsLookupFunction;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultRequestedClaimsLookupFunctionTest
extends BaseDefaultRequestLookupFunctionTest {
    private DefaultRequestedClaimsLookupFunction lookup;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.lookup = new DefaultRequestedClaimsLookupFunction();
    }

    @Test
    public void testSuccessNoReqObject() {
        ClaimsSetRequest idTokenClaims = new ClaimsSetRequest().add(new ClaimsSetRequest.Entry("sub").withClaimRequirement(ClaimRequirement.ESSENTIAL));
        ClaimsSetRequest userInfoClaims = new ClaimsSetRequest().add(new ClaimsSetRequest.Entry("birthdate").withClaimRequirement(ClaimRequirement.ESSENTIAL));
        OIDCClaimsRequest cr = new OIDCClaimsRequest().withIDTokenClaimsRequest(idTokenClaims).withUserInfoClaimsRequest(userInfoClaims);
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).claims(cr).state(new State()).build();
        this.msgCtx.setMessage((Object)req);
        Assert.assertEquals((Map)cr.toJSONObject(), (Map)((OIDCClaimsRequest)this.lookup.apply(this.prc)).toJSONObject());
    }

    @Test
    public void testSuccessReqObject() throws ParseException {
        ClaimsSetRequest idTokenClaims = new ClaimsSetRequest().add(new ClaimsSetRequest.Entry("sub").withClaimRequirement(ClaimRequirement.ESSENTIAL));
        OIDCClaimsRequest crParameter = new OIDCClaimsRequest().withIDTokenClaimsRequest(idTokenClaims);
        ClaimsSetRequest userInfoClaims = new ClaimsSetRequest().add(new ClaimsSetRequest.Entry("birthdate").withClaimRequirement(ClaimRequirement.ESSENTIAL));
        OIDCClaimsRequest crRequestObject = new OIDCClaimsRequest().withIDTokenClaimsRequest(idTokenClaims).withUserInfoClaimsRequest(userInfoClaims);
        JWTClaimsSet ro = new JWTClaimsSet.Builder().claim("claims", (Object)crRequestObject.toJSONObject()).build();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).claims(crParameter).requestObject((JWT)PlainJWT.parse((String)new PlainJWT(ro).serialize())).state(new State()).build();
        this.msgCtx.setMessage((Object)req);
        this.oidcCtx.setRequestObject(req.getRequestObject());
        Assert.assertEquals((Map)crRequestObject.toJSONObject(), (Map)((OIDCClaimsRequest)this.lookup.apply(this.prc)).toJSONObject());
    }
}

