/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.net.URI;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.BaseDefaultRequestLookupFunctionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestedScopeLookupFunction;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultRequestedScopeLookupFunctionTest
extends BaseDefaultRequestLookupFunctionTest {
    private DefaultRequestedScopeLookupFunction lookup;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.lookup = new DefaultRequestedScopeLookupFunction();
    }

    @Test
    public void testSuccessNoReqObject() {
        Scope parameterScope = new Scope(new String[]{"openid", "email"});
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), parameterScope, new ClientID("000123"), URI.create("https://example.com/callback")).state(new State()).build();
        this.msgCtx.setMessage((Object)req);
        Assert.assertTrue((boolean)((Scope)this.lookup.apply(this.prc)).contains("openid"));
        Assert.assertTrue((boolean)((Scope)this.lookup.apply(this.prc)).contains("email"));
        Assert.assertEquals((int)2, (int)((Scope)this.lookup.apply(this.prc)).size());
    }

    @Test
    public void testSuccessReqObject() {
        Scope parameterScope = new Scope(new String[]{"openid"});
        JWTClaimsSet ro = new JWTClaimsSet.Builder().claim("scope", (Object)"openid email").build();
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), parameterScope, new ClientID("000123"), URI.create("https://example.com/callback")).state(new State()).requestObject((JWT)new PlainJWT(ro)).build();
        this.msgCtx.setMessage((Object)req);
        this.oidcCtx.setRequestObject(req.getRequestObject());
        Assert.assertTrue((boolean)((Scope)this.lookup.apply(this.prc)).contains("openid"));
        Assert.assertTrue((boolean)((Scope)this.lookup.apply(this.prc)).contains("email"));
        Assert.assertEquals((int)2, (int)((Scope)this.lookup.apply(this.prc)).size());
    }
}

