/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import java.util.ArrayList;
import java.util.Date;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultResponseClaimsSetLookupFunction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultResponseClaimsSetLookupFunctionTest {
    private DefaultResponseClaimsSetLookupFunction lookup;
    private ProfileRequestContext prc;
    private OIDCAuthenticationResponseContext oidcCtx;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.lookup = new DefaultResponseClaimsSetLookupFunction();
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        this.prc.setOutboundMessageContext(new MessageContext());
        this.oidcCtx = new OIDCAuthenticationResponseContext();
        this.prc.getOutboundMessageContext().addSubcontext((BaseContext)this.oidcCtx);
        Issuer issuer = new Issuer("iss");
        Subject sub = new Subject("sub");
        ArrayList<Audience> aud = new ArrayList<Audience>();
        aud.add(new Audience("aud"));
        this.oidcCtx.setIDToken(new IDTokenClaimsSet(issuer, sub, aud, new Date(), new Date()));
    }

    @Test
    public void testSuccess() {
        Assert.assertEquals((String)"sub", (String)((String)this.lookup.apply(this.prc).getClaim("sub")));
    }

    @Test
    public void testNoInput() {
        Assert.assertNull((Object)this.lookup.apply(null));
        this.oidcCtx.setIDToken(null);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
        this.prc.getOutboundMessageContext().removeSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
        this.prc.setOutboundMessageContext(null);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
    }
}

