/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.token.support;

import java.text.ParseException;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.testing.BaseTokenClaimsSetTest;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AccessTokenClaimsSetTest
extends BaseTokenClaimsSetTest {
    private AccessTokenClaimsSet atClaimsSet;

    protected void init() {
        this.atClaimsSet = (AccessTokenClaimsSet)new AccessTokenClaimsSet.Builder().setJWTID((IdentifierGenerationStrategy)new SecureRandomIdentifierGenerationStrategy()).setClientID(this.clientID).setIssuer(this.issuer).setPrincipal(this.userPrincipal).setSubject(this.subject).setIssuedAt(this.iat).setExpiresAt(this.exp).setAuthenticationTime(this.authTime).setRedirectURI(this.redirectURI).setScope(this.scope).setACR(this.acr).build();
    }

    protected void init2() {
        AuthorizeCodeClaimsSet acClaimsSet = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID((IdentifierGenerationStrategy)new SecureRandomIdentifierGenerationStrategy()).setClientID(this.clientID).setIssuer(this.issuer).setPrincipal(this.userPrincipal).setSubject(this.subject).setIssuedAt(this.iat).setExpiresAt(this.exp).setAuthenticationTime(this.authTime).setRedirectURI(this.redirectURI).setScope(this.scope).setACR(this.acr).build();
        this.atClaimsSet = new AccessTokenClaimsSet.Builder((TokenClaimsSet)acClaimsSet, this.scope, this.dlClaims, this.dlClaimsUI, this.iat, this.exp).build();
    }

    @Test
    public void testConstructorSimple() throws ParseException, DataSealerException {
        this.init();
        Assert.assertEquals((String)this.atClaimsSet.getACR(), (String)this.acr.getValue());
        this.init2();
        Assert.assertEquals((String)this.atClaimsSet.getACR(), (String)this.acr.getValue());
    }

    @Test
    public void testSerialization() throws ParseException, DataSealerException {
        this.init();
        AccessTokenClaimsSet acClaimsSet2 = AccessTokenClaimsSet.parse((String)this.atClaimsSet.serialize());
        Assert.assertEquals((String)acClaimsSet2.getACR(), (String)this.acr.getValue());
        AccessTokenClaimsSet acClaimsSet3 = AccessTokenClaimsSet.parse((String)acClaimsSet2.serialize(this.sealer), (DataSealer)this.sealer);
        Assert.assertEquals((String)acClaimsSet3.getACR(), (String)this.acr.getValue());
    }

    @Test(expectedExceptions={ParseException.class})
    public void testSerializationWrongType() throws ParseException {
        AuthorizeCodeClaimsSet accessnClaimsSet = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID((IdentifierGenerationStrategy)new SecureRandomIdentifierGenerationStrategy()).setClientID(this.clientID).setIssuer(this.issuer).setPrincipal(this.userPrincipal).setSubject(this.subject).setIssuedAt(this.iat).setExpiresAt(this.exp).setAuthenticationTime(this.authTime).setRedirectURI(this.redirectURI).setScope(this.scope).setACR(this.acr).build();
        this.atClaimsSet = AccessTokenClaimsSet.parse((String)accessnClaimsSet.serialize());
    }
}

