/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.token.support;

import java.text.ParseException;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.testing.BaseTokenClaimsSetTest;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RefreshTokenClaimsSetTest
extends BaseTokenClaimsSetTest {
    private RefreshTokenClaimsSet rfClaimsSet;

    protected void init() {
        AuthorizeCodeClaimsSet acClaimsSet = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID((IdentifierGenerationStrategy)new SecureRandomIdentifierGenerationStrategy()).setClientID(this.clientID).setIssuer(this.issuer).setPrincipal(this.userPrincipal).setSubject(this.subject).setIssuedAt(this.iat).setExpiresAt(this.exp).setAuthenticationTime(this.authTime).setRedirectURI(this.redirectURI).setScope(this.scope).setACR(this.acr).build();
        this.rfClaimsSet = new RefreshTokenClaimsSet.Builder((TokenClaimsSet)acClaimsSet, this.iat, this.exp).build();
    }

    @Test
    public void testSerialization() throws ParseException, DataSealerException {
        this.init();
        RefreshTokenClaimsSet rfClaimsSet2 = RefreshTokenClaimsSet.parse((String)this.rfClaimsSet.serialize());
        Assert.assertEquals((String)rfClaimsSet2.getACR(), (String)this.acr.getValue());
        RefreshTokenClaimsSet rfClaimsSet3 = RefreshTokenClaimsSet.parse((String)rfClaimsSet2.serialize(this.sealer), (DataSealer)this.sealer);
        Assert.assertEquals((String)rfClaimsSet3.getACR(), (String)this.acr.getValue());
    }

    @Test(expectedExceptions={ParseException.class})
    public void testSerializationWrongType() throws ParseException {
        AuthorizeCodeClaimsSet accessnClaimsSet = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID((IdentifierGenerationStrategy)new SecureRandomIdentifierGenerationStrategy()).setClientID(this.clientID).setIssuer(this.issuer).setPrincipal(this.userPrincipal).setSubject(this.subject).setIssuedAt(this.iat).setExpiresAt(this.exp).setAuthenticationTime(this.authTime).setRedirectURI(this.redirectURI).setScope(this.scope).setACR(this.acr).build();
        this.rfClaimsSet = RefreshTokenClaimsSet.parse((String)accessnClaimsSet.serialize());
    }
}

