/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.token.support.testing;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import net.minidev.json.JSONArray;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenDeliveryClaimsClaimsSet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerKeyStrategy;
import net.shibboleth.utilities.java.support.security.impl.BasicKeystoreKeyStrategy;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.annotations.BeforeMethod;

public class BaseTokenClaimsSetTest {
    protected DataSealer sealer;
    protected String subject = "sub";
    protected String userPrincipal = "userid";
    protected String issuer = "https://op.example.com";
    protected ClientID clientID = new ClientID();
    protected ACR acr = new ACR("0");
    protected Scope scope = new Scope(new String[]{"openid"});
    protected Nonce nonce = new Nonce();
    protected ClaimsSet dlClaimsUI = new TokenDeliveryClaimsClaimsSet();
    protected Instant iat = Instant.now();
    protected URI redirectURI;
    protected Instant exp = Instant.now().plusSeconds(3600L);
    protected ClaimsSet dlClaims = new TokenDeliveryClaimsClaimsSet();
    protected String idpSessionId = "sessionId";
    protected Instant authTime = Instant.now();
    protected boolean consentEnabled = false;
    protected ClaimsSet dlClaimsID = new TokenDeliveryClaimsClaimsSet();
    protected JSONArray consentedClaims = new JSONArray();
    protected OIDCClaimsRequest claims;
    protected String codeChallenge = "code_challenge_123456";

    @BeforeMethod
    protected void setupSealer() throws ComponentInitializationException, NoSuchAlgorithmException {
        this.sealer = new DataSealer();
        BasicKeystoreKeyStrategy strategy = new BasicKeystoreKeyStrategy();
        strategy.setKeystoreResource(ResourceHelper.of((Resource)new ClassPathResource("credentials/sealer.jks")));
        strategy.setKeyVersionResource(ResourceHelper.of((Resource)new ClassPathResource("credentials/sealer.kver")));
        strategy.setKeystorePassword("password");
        strategy.setKeyAlias("secret");
        strategy.setKeyPassword("password");
        strategy.initialize();
        this.sealer.setKeyStrategy((DataSealerKeyStrategy)strategy);
        this.sealer.setRandom(SecureRandom.getInstance("SHA1PRNG"));
        this.sealer.initialize();
    }

    @BeforeMethod
    protected void setUpParameters() throws Exception {
        this.redirectURI = new URI("https://rp.example.com/cb");
        ClaimsSetRequest idTokenClaims = new ClaimsSetRequest().add("email");
        this.claims = new OIDCClaimsRequest().withIDTokenClaimsRequest(idTokenClaims);
        this.dlClaims.setClaim("tokenDelivery", (Object)"value");
        this.dlClaimsID.setClaim("tokenToIdtokenDeliveryClaim", (Object)"value");
        this.dlClaimsUI.setClaim("tokenToUserInfotokenDeliveryClaim", (Object)"value");
        this.consentedClaims.add((Object)"consentedClaim");
    }
}

