/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributesMapContainer;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import org.opensaml.messaging.context.BaseContext;

public class OIDCAuthenticationResponseContext
extends BaseContext {
    @Nullable
    private IDTokenClaimsSet idToken;
    @Nullable
    private JWT requestObject;
    @Nullable
    private UserInfo userInfo;
    @Nullable
    private ClaimsSet accessTokenClaimsSet;
    @Nullable
    private JWT processedToken;
    @Nullable
    private ACR acr;
    @Nullable
    private URI redirectURI;
    @Nullable
    private Instant authTime;
    @Nullable
    private Scope validatedScope;
    @Nonnull
    @NonnullElements
    private List<String> validatedAudience = new ArrayList<String>();
    @Nullable
    private String requestedSubject;
    @Nullable
    private String subject;
    @Nullable
    private String subjectType;
    @Nullable
    private AuthorizationCode authorizationCode;
    @Nullable
    private AccessToken accessToken;
    @Nullable
    private RefreshToken refreshToken;
    @Nullable
    private TokenClaimsSet authorizationGrantClaims;
    @Nullable
    private OIDCClaimsRequest requestedClaims;
    @Nullable
    private AttributesMapContainer mappedIdTokenRequestedClaims;
    @Nullable
    private AttributesMapContainer mappedUserinfoRequestedClaims;
    @Nullable
    private String sessionId;

    @Nullable
    public OIDCClaimsRequest getRequestedClaims() {
        return this.requestedClaims;
    }

    public void setRequestedClaims(@Nullable OIDCClaimsRequest claims) {
        this.requestedClaims = claims;
    }

    @Nullable
    public AttributesMapContainer getMappedIdTokenRequestedClaims() {
        return this.mappedIdTokenRequestedClaims;
    }

    public void setMappedIdTokenRequestedClaims(@Nullable AttributesMapContainer container) {
        this.mappedIdTokenRequestedClaims = container;
    }

    @Nullable
    public AttributesMapContainer getMappedUserinfoRequestedClaims() {
        return this.mappedUserinfoRequestedClaims;
    }

    public void setMappedUserinfoRequestedClaims(@Nullable AttributesMapContainer container) {
        this.mappedUserinfoRequestedClaims = container;
    }

    @Nullable
    public TokenClaimsSet getAuthorizationGrantClaimsSet() {
        return this.authorizationGrantClaims;
    }

    public void setAuthorizationGrantClaimsSet(@Nullable TokenClaimsSet claims) {
        this.authorizationGrantClaims = claims;
    }

    @Nullable
    public AuthorizationCode getAuthorizationCode() {
        return this.authorizationCode;
    }

    public void setAuthorizationCode(@Nullable String code) {
        this.authorizationCode = code == null ? null : new AuthorizationCode(code);
    }

    @Nullable
    public String getRequestedSubject() {
        return this.requestedSubject;
    }

    public void setRequestedSubject(@Nullable String sub) {
        this.requestedSubject = sub;
    }

    @Nullable
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(@Nullable String generatedSubject) {
        this.subject = generatedSubject;
    }

    @Nullable
    public String getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(@Nullable String type) {
        this.subjectType = type;
    }

    @Nullable
    public Scope getScope() {
        return this.validatedScope;
    }

    public void setScope(@Nullable Scope scope) {
        this.validatedScope = scope;
    }

    @Nonnull
    @NonnullElements
    @Live
    public List<String> getAudience() {
        return this.validatedAudience;
    }

    @Nullable
    public Instant getAuthTime() {
        return this.authTime;
    }

    public void setAuthTime(@Nullable Instant time) {
        this.authTime = time;
    }

    @Nullable
    public URI getRedirectURI() {
        return this.redirectURI;
    }

    public void setRedirectURI(@Nullable URI uri) {
        this.redirectURI = uri;
    }

    @Nullable
    public ACR getAcr() {
        return this.acr;
    }

    public void setAcr(@Nullable String acrValue) {
        this.acr = acrValue != null ? new ACR(acrValue) : null;
    }

    @Nullable
    public IDTokenClaimsSet getIDToken() {
        return this.idToken;
    }

    public void setIDToken(@Nullable IDTokenClaimsSet token) {
        this.idToken = token;
    }

    @Nullable
    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public void setUserInfo(@Nullable UserInfo info) {
        this.userInfo = info;
    }

    @Nullable
    public ClaimsSet getAccessTokenClaimSet() {
        return this.accessTokenClaimsSet;
    }

    public void setAccessTokenClaimsSet(@Nullable ClaimsSet claims) {
        this.accessTokenClaimsSet = claims;
    }

    @Nullable
    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(@Nullable String token, @Nonnull Duration lifeTime) {
        this.setAccessToken(token, lifeTime, null);
    }

    public void setAccessToken(@Nullable String token, @Nonnull Duration lifeTime, @Nullable Scope scope) {
        this.accessToken = token == null ? null : new BearerAccessToken(token, lifeTime.getSeconds(), scope);
    }

    @Nullable
    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(@Nullable String token) {
        this.refreshToken = token == null ? null : new RefreshToken(token);
    }

    @Nullable
    public JWT getProcessedToken() {
        return this.processedToken;
    }

    public void setProcessedToken(@Nullable JWT token) {
        this.processedToken = token;
    }

    @Nullable
    public JWT getRequestObject() {
        return this.requestObject;
    }

    public void setRequestObject(@Nullable JWT obj) {
        this.requestObject = obj;
    }

    @Nullable
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(@Nullable String sid) {
        this.sessionId = sid;
    }
}

