/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.logic;

import com.nimbusds.jose.Payload;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.AccessTokenContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.slf4j.Logger;

public class PayloadFromJWTAccessTokenLookupFunction
implements Function<MessageContext, Payload> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(PayloadFromJWTAccessTokenLookupFunction.class);
    @Nonnull
    private Function<MessageContext, AccessTokenContext> accessTokenContextLookupStrategy;

    public PayloadFromJWTAccessTokenLookupFunction() {
        Function atcls = new ChildContextLookup(AccessTokenContext.class).compose((Function)new ChildContextLookup(OIDCAuthenticationResponseContext.class));
        assert (atcls != null);
        this.accessTokenContextLookupStrategy = atcls;
    }

    public void setAccessTokenContextCreationStrategy(@Nonnull Function<MessageContext, AccessTokenContext> strategy) {
        this.accessTokenContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AccessTokenContext lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public Payload apply(@Nullable MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        AccessTokenContext tokenCtx = this.accessTokenContextLookupStrategy.apply(messageContext);
        if (tokenCtx == null || tokenCtx.getJWT() == null) {
            return null;
        }
        JWT jWT = tokenCtx.getJWT();
        if (jWT instanceof SignedJWT) {
            SignedJWT signedJwt = (SignedJWT)jWT;
            return new Payload(signedJwt);
        }
        jWT = tokenCtx.getJWT();
        if (jWT instanceof PlainJWT) {
            PlainJWT plainJwt = (PlainJWT)jWT;
            try {
                return new Payload(plainJwt.getJWTClaimsSet().getClaims());
            }
            catch (ParseException e) {
                this.log.error("Unable to convert plaintext JWT to claims set", (Throwable)e);
            }
        }
        return null;
    }
}

