/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.messaging.context.logic;

import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.TokenRequest;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class RequestedGrantTypesCondition
implements Predicate<ProfileRequestContext> {
    @Nonnull
    @NonnullElements
    private Set<GrantType> candidates = CollectionSupport.emptySet();

    public void setGrantTypes(@Nonnull @NonnullElements Collection<GrantType> types) {
        this.candidates = CollectionSupport.copyToSet(types);
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input) {
        if (input == null || input.getInboundMessageContext() == null) {
            return false;
        }
        Object message = input.ensureInboundMessageContext().getMessage();
        if (message instanceof TokenRequest) {
            TokenRequest tokenRequest = (TokenRequest)message;
            return this.candidates.contains(tokenRequest.getAuthorizationGrant().getType());
        }
        return false;
    }
}

