/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractAuthorizationRequestLookupFunction<T>
implements ContextDataLookupFunction<ProfileRequestContext, T> {
    @Nullable
    private JWT requestObject;
    @Nonnull
    private final Class<? extends AuthorizationRequest> messageClass;

    public AbstractAuthorizationRequestLookupFunction() {
        this(AuthorizationRequest.class);
    }

    protected AbstractAuthorizationRequestLookupFunction(@Nonnull Class<? extends AuthorizationRequest> clazz) {
        this.messageClass = (Class)Constraint.isNotNull(clazz, (String)"Message class cannot be null");
    }

    @Nullable
    protected abstract T doLookup(@Nonnull AuthorizationRequest var1);

    @Nullable
    public T apply(@Nullable ProfileRequestContext input) {
        OIDCAuthenticationResponseContext ctx;
        if (input == null || input.getInboundMessageContext() == null) {
            return null;
        }
        Object message = input.ensureInboundMessageContext().getMessage();
        if (message == null || !this.messageClass.isInstance(message)) {
            return null;
        }
        if (input.getOutboundMessageContext() != null && (ctx = (OIDCAuthenticationResponseContext)input.ensureOutboundMessageContext().getSubcontext(OIDCAuthenticationResponseContext.class)) != null) {
            this.requestObject = ctx.getRequestObject();
        }
        return this.doLookup((AuthorizationRequest)message);
    }

    @Nullable
    public JWT getRequestObject() {
        return this.requestObject;
    }
}

