/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractAuthorizationRequestLookupFunction;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultRequestAudienceLookupFunction
extends AbstractAuthorizationRequestLookupFunction<List<String>> {
    public static final String CUSTOM_RESOURCE_PARAM_NAME = "shibboleth.oidc.op.resource";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestAudienceLookupFunction.class);

    @Override
    @Nullable
    protected List<String> doLookup(@Nonnull AuthorizationRequest req) {
        JWT requestObject = this.getRequestObject();
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getClaim("resource") != null) {
                Object resource = requestObject.getJWTClaimsSet().getClaim("resource");
                if (resource instanceof String) {
                    String string = (String)resource;
                    return Collections.singletonList(string);
                }
                if (resource instanceof List) {
                    return (List)resource;
                }
                if (resource != null) {
                    this.log.error("resource claim is not of expected type");
                    return null;
                }
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse request object");
            return null;
        }
        return req.getCustomParameter(CUSTOM_RESOURCE_PARAM_NAME);
    }
}

