/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import java.text.ParseException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractAuthorizationRequestLookupFunction;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultRequestCodeChallengeMethodLookupFunction
extends AbstractAuthorizationRequestLookupFunction<String> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestCodeChallengeMethodLookupFunction.class);

    @Override
    protected String doLookup(@Nonnull AuthorizationRequest req) {
        JWT requestObject = this.getRequestObject();
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getClaim("code_challenge_method") != null) {
                Object codeChallenge = requestObject.getJWTClaimsSet().getClaim("code_challenge_method");
                if (codeChallenge instanceof String) {
                    String string = (String)codeChallenge;
                    return string;
                }
                this.log.error("code_challenge_method claim is not of expected type");
                return null;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse code challenge method  from request object code_challenge_method value");
            return null;
        }
        return req.getCodeChallengeMethod() == null ? null : req.getCodeChallengeMethod().getValue();
    }
}

