/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.text.ParseException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultRequestLoginHintLookupFunction
extends AbstractAuthenticationRequestLookupFunction<String> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestLoginHintLookupFunction.class);

    @Override
    protected String doLookup(@Nonnull AuthenticationRequest req) {
        JWT requestObject = this.getRequestObject();
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getClaim("login_hint") != null) {
                Object hint = requestObject.getJWTClaimsSet().getClaim("login_hint");
                if (hint instanceof String) {
                    return (String)hint;
                }
                this.log.error("login_hint claim is not of expected type");
                return null;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse login hint from request object login_hint value");
            return null;
        }
        return req.getLoginHint();
    }
}

