/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.ResponseMode;
import java.text.ParseException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractAuthorizationRequestLookupFunction;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultRequestResponseModeLookupFunction
extends AbstractAuthorizationRequestLookupFunction<ResponseMode> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestResponseModeLookupFunction.class);

    @Override
    protected ResponseMode doLookup(@Nonnull AuthorizationRequest req) {
        JWT requestObject = this.getRequestObject();
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getClaim("response_mode") != null) {
                Object rMode = requestObject.getJWTClaimsSet().getClaim("response_mode");
                if (rMode instanceof String) {
                    return new ResponseMode((String)rMode);
                }
                this.log.error("response_mode claim is not of expected type");
                return null;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse response mode from request object response_mode value");
            return null;
        }
        if (req.getResponseMode() == null) {
            return null;
        }
        return new ResponseMode(req.getResponseMode().getValue());
    }
}

