/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.id.State;
import java.text.ParseException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractAuthorizationRequestLookupFunction;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultRequestStateLookupFunction
extends AbstractAuthorizationRequestLookupFunction<State> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestStateLookupFunction.class);

    @Override
    protected State doLookup(@Nonnull AuthorizationRequest req) {
        JWT requestObject = this.getRequestObject();
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getClaim("state") != null) {
                Object state = requestObject.getJWTClaimsSet().getClaim("state");
                if (state instanceof String) {
                    String string = (String)state;
                    return new State(string);
                }
                this.log.error("state claim is not of expected type");
                return null;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse state from request object state value");
            return null;
        }
        if (req.getState() == null) {
            return null;
        }
        return new State(req.getState().getValue());
    }
}

