/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultRequestedAcrLookupFunction
extends AbstractAuthenticationRequestLookupFunction<List<ACR>> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DefaultRequestedAcrLookupFunction.class);

    @Override
    protected List<ACR> doLookup(@Nonnull AuthenticationRequest req) {
        JWT requestObject = this.getRequestObject();
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getClaim("acr_values") != null) {
                String[] acrs;
                ArrayList<ACR> reqObjectAcr = new ArrayList<ACR>();
                for (String acr : acrs = ((String)requestObject.getJWTClaimsSet().getClaim("acr_values")).split(" ")) {
                    reqObjectAcr.add(new ACR(acr));
                }
                return reqObjectAcr;
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse acr values from request object acr_values value");
            return null;
        }
        if (req.getACRValues() == null) {
            return null;
        }
        ArrayList<ACR> requestParameterAcr = new ArrayList<ACR>();
        requestParameterAcr.addAll(req.getACRValues());
        return requestParameterAcr;
    }
}

