/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.context.navigate;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCMetadataContextLookupFunction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SectorIdentifierLookupFunction
extends AbstractIdentifiableInitializableComponent
implements ContextDataLookupFunction<ProfileRequestContext, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SectorIdentifierLookupFunction.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcMetadataContextLookupStrategy = new DefaultOIDCMetadataContextLookupFunction();

    public void setOIDCMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strategy) {
        this.oidcMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCMetadata lookup strategy cannot be null");
    }

    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        if (input == null) {
            return null;
        }
        OIDCMetadataContext ctx = this.oidcMetadataContextLookupStrategy.apply(input);
        if (ctx == null) {
            this.log.warn("OIDC metadata not available, no sector identifier can be resolved");
            return null;
        }
        OIDCClientInformation clientInformation = ctx.getClientInformation();
        if (clientInformation == null || clientInformation.getOIDCMetadata() == null) {
            this.log.warn("OIDC metadata not available, no sector identifier can be resolved");
            return null;
        }
        OIDCClientMetadata clientMetadata = clientInformation.getOIDCMetadata();
        if (clientMetadata.getSectorIDURI() != null) {
            String sectorIdentifier = clientMetadata.getSectorIDURI().getHost();
            this.log.debug("Sector identifier resolved by registered sector uri {}", (Object)sectorIdentifier);
            return sectorIdentifier;
        }
        if (clientMetadata.getRedirectionURIs() == null) {
            this.log.warn("Redirection uri not available, unable to determine sector identifier");
            return null;
        }
        Set hosts = clientMetadata.getRedirectionURIs().stream().map(URI::getHost).collect(Collectors.toSet());
        if (hosts.size() > 1) {
            this.log.warn("Multiple hosts found from the redirection uris but no registered sector uri");
            return null;
        }
        String sectorIdentifier = (String)hosts.stream().findFirst().get();
        this.log.debug("Sector identifier by single host from redirect uris: {}", (Object)sectorIdentifier);
        return sectorIdentifier;
    }
}

