/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.token.support;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.text.ParseException;
import java.time.Instant;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;

public final class AccessTokenClaimsSet
extends TokenClaimsSet {
    @Nonnull
    @NotEmpty
    protected static final String VALUE_TYPE_AT = "at";

    protected AccessTokenClaimsSet(@Nonnull JWTClaimsSet accessTokenClaimsSet) {
        super(accessTokenClaimsSet);
    }

    @Nonnull
    public static AccessTokenClaimsSet parse(@Nonnull @NotEmpty String accessTokenClaimsSet) throws ParseException {
        JWTClaimsSet atClaimsSet = JWTClaimsSet.parse((String)accessTokenClaimsSet);
        assert (atClaimsSet != null);
        AccessTokenClaimsSet.verifyParsedClaims(VALUE_TYPE_AT, atClaimsSet);
        return new AccessTokenClaimsSet(atClaimsSet);
    }

    @Nonnull
    public static AccessTokenClaimsSet parse(@Nonnull @NotEmpty String wrappedAccessToken, @Nonnull DataSealer dataSealer) throws ParseException, DataSealerException {
        return AccessTokenClaimsSet.parse(dataSealer.unwrap(wrappedAccessToken));
    }

    @Nonnull
    public static AccessTokenClaimsSet parse(@Nonnull @NotEmpty JWT jwtAccessToken, @Nonnull DataSealer dataSealer) throws ParseException, DataSealerException {
        JWTClaimsSet claims = jwtAccessToken.getJWTClaimsSet();
        String sealedClaim = (String)claims.getClaim("for_op");
        if (sealedClaim == null) {
            AccessTokenClaimsSet.verifyParsedClaims(VALUE_TYPE_AT, claims);
            return new AccessTokenClaimsSet(claims);
        }
        Map map = claims.toJSONObject();
        JWTClaimsSet unsealed = JWTClaimsSet.parse((String)dataSealer.unwrap(sealedClaim));
        map.remove("for_op");
        for (Map.Entry claim : unsealed.getClaims().entrySet()) {
            map.put((String)claim.getKey(), claim.getValue());
        }
        claims = JWTClaimsSet.parse((Map)map);
        assert (claims != null);
        AccessTokenClaimsSet.verifyParsedClaims(VALUE_TYPE_AT, claims);
        return new AccessTokenClaimsSet(claims);
    }

    public static final class Builder
    extends TokenClaimsSet.Builder<AccessTokenClaimsSet> {
        public Builder() {
        }

        public Builder(@Nonnull TokenClaimsSet existing, @Nonnull Scope scope, @Nullable ClaimsSet dlClaims, @Nullable ClaimsSet dlClaimsUI, @Nonnull Instant iat, @Nonnull Instant exp) {
            this(existing);
            this.setScope(scope);
            this.setDlClaims(dlClaims);
            this.setDlClaimsUI(dlClaimsUI);
            this.setIssuedAt(iat);
            this.setExpiresAt(exp);
        }

        private Builder(@Nonnull TokenClaimsSet existing) {
            this.setJWTID(Constraint.isNotEmpty((String)existing.getID(), (String)"JWT ID cannot be empty"));
            this.setClientID((ClientID)Constraint.isNotNull((Object)existing.getClientID(), (String)"Client ID cannot be null"));
            this.setIssuer(Constraint.isNotEmpty((String)existing.assertedClaimsSet().getIssuer(), (String)"Issuer cannot be empty"));
            this.setPrincipal(Constraint.isNotEmpty((String)existing.getPrincipal(), (String)"Principal cannot be empty"));
            this.setSubject(Constraint.isNotEmpty((String)existing.assertedClaimsSet().getSubject(), (String)"Subject cannot be empty"));
            this.setACR(existing.getACR() == null ? null : new ACR(existing.getACR()));
            this.setNonce(existing.getNonce());
            this.setNotBefore(existing.getNotBefore());
            this.setAuthenticationTime((Instant)Constraint.isNotNull((Object)existing.getAuthenticationTime(), (String)"Authentication time cannot be null"));
            this.setAudience(existing.getAudience());
            this.setClaimsRequest(existing.getClaimsRequest());
            this.setConsentedClaims(existing.getConsentedClaims());
            this.setConsentEnabled(existing.isConsentEnabled());
            this.setRootTokenIdentifier(existing.getRootTokenIdentifier());
            this.setSessionIdentifier(existing.getSessionIdentifier());
        }

        @Override
        public AccessTokenClaimsSet build() {
            return new AccessTokenClaimsSet(this.buildJWTClaimsSet(AccessTokenClaimsSet.VALUE_TYPE_AT));
        }
    }
}

