/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.token.support;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.net.URI;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;

public final class RefreshTokenClaimsSet
extends TokenClaimsSet {
    @Nonnull
    @NotEmpty
    public static final String KEY_CHAIN_EXPIRATION_TIME = "c_exp";
    @Nonnull
    @NotEmpty
    private static final String VALUE_TYPE_RF = "rf";

    private RefreshTokenClaimsSet(@Nonnull JWTClaimsSet refreshTokenClaimsSet) {
        super(refreshTokenClaimsSet);
    }

    @Nullable
    public Instant getChainExp() {
        JWTClaimsSet tokenClaimsSet = this.assertedClaimsSet();
        try {
            Date date;
            if (tokenClaimsSet.getClaims().containsKey(KEY_CHAIN_EXPIRATION_TIME) && (date = tokenClaimsSet.getDateClaim(KEY_CHAIN_EXPIRATION_TIME)) != null) {
                return date.toInstant();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    @Nonnull
    public static RefreshTokenClaimsSet parse(@Nonnull @NotEmpty String refreshTokenClaimsSet) throws ParseException {
        JWTClaimsSet atClaimsSet = JWTClaimsSet.parse((String)refreshTokenClaimsSet);
        assert (atClaimsSet != null);
        RefreshTokenClaimsSet.verifyParsedClaims(VALUE_TYPE_RF, atClaimsSet);
        if (atClaimsSet.getClaims().containsKey(KEY_CHAIN_EXPIRATION_TIME)) {
            atClaimsSet.getDateClaim(KEY_CHAIN_EXPIRATION_TIME);
        }
        return new RefreshTokenClaimsSet(atClaimsSet);
    }

    @Nonnull
    public static RefreshTokenClaimsSet parse(@Nonnull @NotEmpty String wrappedAccessToken, @Nonnull DataSealer dataSealer) throws ParseException, DataSealerException {
        return RefreshTokenClaimsSet.parse(dataSealer.unwrap(wrappedAccessToken));
    }

    public static final class Builder
    extends TokenClaimsSet.Builder<RefreshTokenClaimsSet> {
        public Builder() {
        }

        public Builder(@Nonnull TokenClaimsSet existing, @Nonnull Instant iat, @Nonnull Instant exp) {
            this(existing);
            this.setIssuedAt(iat);
            this.setExpiresAt(exp);
        }

        public Builder(@Nonnull TokenClaimsSet existing, @Nonnull Instant iat, @Nonnull Instant exp, @Nonnull Instant chainExp) {
            this(existing);
            this.setIssuedAt(iat);
            this.setExpiresAt(exp);
            this.setChainExpiresAt(chainExp);
        }

        private Builder(@Nonnull TokenClaimsSet existing) {
            this.setJWTID(Constraint.isNotEmpty((String)existing.getID(), (String)"JWT ID cannot be empty"));
            this.setNotBefore(existing.getNotBefore());
            this.setClientID((ClientID)Constraint.isNotNull((Object)existing.getClientID(), (String)"Client ID cannot be null"));
            this.setIssuer(Constraint.isNotEmpty((String)existing.assertedClaimsSet().getIssuer(), (String)"Issuer cannot be empty"));
            this.setPrincipal(Constraint.isNotEmpty((String)existing.getPrincipal(), (String)"Principal cannot be empty"));
            this.setSubject(Constraint.isNotEmpty((String)existing.assertedClaimsSet().getSubject(), (String)"Subject cannot be empty"));
            this.setACR(existing.getACR() == null ? null : new ACR(existing.getACR()));
            this.setAuthenticationTime((Instant)Constraint.isNotNull((Object)existing.getAuthenticationTime(), (String)"Authentication time cannot be null"));
            this.setNonce(existing.getNonce());
            this.setRedirectURI((URI)Constraint.isNotNull((Object)existing.getRedirectURI(), (String)"Redirect URI cannot be null"));
            this.setScope((Scope)Constraint.isNotNull((Object)existing.getScope(), (String)"Scope cannot be null"));
            this.setAudience(existing.getAudience());
            this.setClaimsRequest(existing.getClaimsRequest());
            this.setDlClaims(existing.getDeliveryClaims());
            this.setDlClaimsUI(existing.getUserinfoDeliveryClaims());
            this.setConsentedClaims(existing.getConsentedClaims());
            this.setConsentEnabled(existing.isConsentEnabled());
            this.setSessionIdentifier(existing.getSessionIdentifier());
        }

        public Builder setChainExpiresAt(@Nonnull Instant i) {
            this.addCustomClaim(RefreshTokenClaimsSet.KEY_CHAIN_EXPIRATION_TIME, Date.from(i));
            return this;
        }

        @Override
        @Nonnull
        public RefreshTokenClaimsSet build() {
            return new RefreshTokenClaimsSet(this.buildJWTClaimsSet(RefreshTokenClaimsSet.VALUE_TYPE_RF));
        }
    }
}

