/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.token.support;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.net.URI;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.minidev.json.JSONObject;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.DataSealer;
import net.shibboleth.shared.security.DataSealerException;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.slf4j.Logger;

@NotThreadSafe
public class TokenClaimsSet {
    @Nonnull
    @NotEmpty
    public static final String KEY_AC_ID = "jti";
    @Nonnull
    @NotEmpty
    public static final String KEY_TYPE = "type";
    @Nonnull
    @NotEmpty
    public static final String KEY_ISSUER = "iss";
    @Nonnull
    @NotEmpty
    public static final String KEY_USER_PRINCIPAL = "prncpl";
    @Nonnull
    @NotEmpty
    public static final String KEY_SUBJECT = "sub";
    @Nonnull
    @NotEmpty
    public static final String KEY_CLIENTID = "client_id";
    @Nonnull
    @NotEmpty
    public static final String KEY_LEGACY_CLIENTID = "clid";
    @Nonnull
    @NotEmpty
    public static final String KEY_EXPIRATION_TIME = "exp";
    @Nonnull
    @NotEmpty
    public static final String KEY_NOTBEFORE_TIME = "nbf";
    @Nonnull
    @NotEmpty
    public static final String KEY_ISSUED_AT = "iat";
    @Nonnull
    @NotEmpty
    public static final String KEY_ACR = "acr";
    @Nonnull
    @NotEmpty
    public static final String KEY_NONCE = "nonce";
    @Nonnull
    @NotEmpty
    public static final String KEY_AUTH_TIME = "auth_time";
    @Nonnull
    @NotEmpty
    public static final String KEY_REDIRECT_URI = "redirect_uri";
    @Nonnull
    @NotEmpty
    public static final String KEY_SCOPE = "scope";
    @Nonnull
    @NotEmpty
    public static final String KEY_AUDIENCE = "aud";
    @Nonnull
    @NotEmpty
    public static final String KEY_CLAIMS = "claims";
    @Nonnull
    @NotEmpty
    public static final String KEY_DELIVERY_CLAIMS = "dl_claims";
    @Nonnull
    @NotEmpty
    public static final String KEY_DELIVERY_CLAIMS_IDTOKEN = "dl_claims_id";
    @Nonnull
    @NotEmpty
    public static final String KEY_DELIVERY_CLAIMS_USERINFO = "dl_claims_ui";
    @Nonnull
    @NotEmpty
    public static final String KEY_CONSENTED_CLAIMS = "cnsntd_claims";
    @Nonnull
    @NotEmpty
    public static final String KEY_CONSENT_ENABLED = "cnsnt";
    @Nonnull
    @NotEmpty
    public static final String KEY_CODE_CHALLENGE = "cc";
    @Nonnull
    @NotEmpty
    public static final String KEY_SEALED_FOR_OP = "for_op";
    @Nonnull
    @NotEmpty
    public static final String KEY_ROOT_JTI = "root_jti";
    @Nonnull
    @NotEmpty
    public static final String KEY_SESSION_ID = "sid";
    @Nullable
    private JWTClaimsSet tokenClaimsSet;
    @Nonnull
    private Logger log = LoggerFactory.getLogger(TokenClaimsSet.class);

    protected TokenClaimsSet() {
    }

    protected TokenClaimsSet(@Nonnull JWTClaimsSet jwt) {
        this.setClaimsSet((JWTClaimsSet)Constraint.isNotNull((Object)jwt, (String)"JWTClaimsSet cannot be null"));
    }

    protected static void verifyParsedClaims(@Nonnull @NotEmpty String tokenType, @Nonnull JWTClaimsSet tokenClaimsSet) throws java.text.ParseException {
        if (!tokenType.equals(tokenClaimsSet.getClaims().get(KEY_TYPE))) {
            throw new java.text.ParseException("claim type value not matching", 0);
        }
        if (tokenClaimsSet.getStringClaim(KEY_ISSUER) == null) {
            throw new java.text.ParseException("claim iss must exist and not be null", 0);
        }
        if (tokenClaimsSet.getStringClaim(KEY_SUBJECT) == null) {
            throw new java.text.ParseException("claim sub must exist and not be null", 0);
        }
        if (tokenClaimsSet.getStringClaim(KEY_CLIENTID) == null && tokenClaimsSet.getStringClaim(KEY_LEGACY_CLIENTID) == null) {
            throw new java.text.ParseException("claim client_id (or clid) must exist and not be null", 0);
        }
        if (tokenClaimsSet.getDateClaim(KEY_EXPIRATION_TIME) == null) {
            throw new java.text.ParseException("claim exp must exist and not be null", 0);
        }
        if (tokenClaimsSet.getDateClaim(KEY_ISSUED_AT) == null) {
            throw new java.text.ParseException("claim iat must exist and not be null", 0);
        }
        if (tokenClaimsSet.getStringClaim(KEY_AC_ID) == null) {
            throw new java.text.ParseException("claim jti must exist and not be null", 0);
        }
        if (tokenClaimsSet.getDateClaim(KEY_AUTH_TIME) == null) {
            throw new java.text.ParseException("claim auth_time must exist and not be null", 0);
        }
        if (tokenClaimsSet.getStringClaim(KEY_SCOPE) == null) {
            throw new java.text.ParseException("claim scope must exist and not be null", 0);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_ACR)) {
            tokenClaimsSet.getStringClaim(KEY_ACR);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_CONSENTED_CLAIMS) && !(tokenClaimsSet.getClaim(KEY_CONSENTED_CLAIMS) instanceof List)) {
            throw new java.text.ParseException("consented claims is of wrong type", 0);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_CONSENT_ENABLED)) {
            tokenClaimsSet.getBooleanClaim(KEY_CONSENT_ENABLED);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_CLAIMS)) {
            tokenClaimsSet.getJSONObjectClaim(KEY_CLAIMS);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_DELIVERY_CLAIMS)) {
            tokenClaimsSet.getJSONObjectClaim(KEY_DELIVERY_CLAIMS);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_DELIVERY_CLAIMS_IDTOKEN)) {
            tokenClaimsSet.getJSONObjectClaim(KEY_DELIVERY_CLAIMS_IDTOKEN);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_DELIVERY_CLAIMS_USERINFO)) {
            tokenClaimsSet.getJSONObjectClaim(KEY_DELIVERY_CLAIMS_USERINFO);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_NONCE)) {
            tokenClaimsSet.getStringClaim(KEY_NONCE);
        }
        if (tokenClaimsSet.getClaims().containsKey(KEY_CODE_CHALLENGE)) {
            tokenClaimsSet.getStringClaim(KEY_CODE_CHALLENGE);
        }
    }

    @Nonnull
    @NotEmpty
    public String serialize() {
        Constraint.isNotNull((Object)this.tokenClaimsSet, (String)"JWTClaimsSet cannot be null");
        return Constraint.isNotEmpty((String)JSONObjectUtils.toJSONObject((JWTClaimsSet)this.tokenClaimsSet).toJSONString(), (String)"JWTClaimsSet could not be serialized");
    }

    @Nonnull
    public String serialize(@Nonnull DataSealer dataSealer) throws DataSealerException {
        return dataSealer.wrap(this.serialize(), Instant.ofEpochMilli(((JWTClaimsSet)Constraint.isNotNull((Object)this.tokenClaimsSet, (String)"JWTClaimsSet cannot be null")).getExpirationTime().getTime()));
    }

    public void setClaimsSet(@Nonnull JWTClaimsSet claimsSet) {
        this.tokenClaimsSet = (JWTClaimsSet)Constraint.isNotNull((Object)claimsSet, (String)"JWTClaimsSet cannot be null");
    }

    @Nullable
    public JWTClaimsSet getClaimsSet() {
        return this.tokenClaimsSet;
    }

    @Nonnull
    protected JWTClaimsSet assertedClaimsSet() {
        return (JWTClaimsSet)Constraint.isNotNull((Object)this.tokenClaimsSet, (String)"JWTClaimsSet cannot be null");
    }

    @Nonnull
    @NotEmpty
    public String getIssuer() {
        return Constraint.isNotEmpty((String)this.assertedClaimsSet().getIssuer(), (String)"The issuer cannot be null");
    }

    @Nonnull
    public Instant getIssuedAt() {
        Date issuedAt = (Date)Constraint.isNotNull((Object)this.assertedClaimsSet().getIssueTime(), (String)"The issued at cannot be null");
        Instant iat = issuedAt.toInstant();
        assert (iat != null);
        return iat;
    }

    @Nonnull
    public Instant getExp() {
        Date expiration = (Date)Constraint.isNotNull((Object)this.assertedClaimsSet().getExpirationTime(), (String)"The expiration time cannot be null");
        Instant exp = expiration.toInstant();
        assert (exp != null);
        return exp;
    }

    @Nullable
    public Instant getNotBefore() {
        Date d = this.assertedClaimsSet().getNotBeforeTime();
        return d != null ? d.toInstant() : null;
    }

    public boolean isTimeValid() {
        Instant now = Instant.now();
        if (this.getExp().isAfter(now)) {
            Instant nbf = this.getNotBefore();
            return nbf == null || now == nbf || now.isAfter(nbf);
        }
        return false;
    }

    @Nullable
    public URI getRedirectURI() {
        try {
            return URI.create(this.assertedClaimsSet().getStringClaim(KEY_REDIRECT_URI));
        }
        catch (IllegalArgumentException | java.text.ParseException e) {
            this.log.error("error parsing redirect uri from token", (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    public String getACR() {
        return (String)this.assertedClaimsSet().getClaim(KEY_ACR);
    }

    @Nullable
    public String getType() {
        return (String)this.assertedClaimsSet().getClaim(KEY_TYPE);
    }

    @Nullable
    public String getPrincipal() {
        return (String)this.assertedClaimsSet().getClaim(KEY_USER_PRINCIPAL);
    }

    @Nullable
    public String getSubject() {
        return (String)this.assertedClaimsSet().getClaim(KEY_SUBJECT);
    }

    @Nullable
    public Instant getAuthenticationTime() {
        try {
            Date date = this.assertedClaimsSet().getDateClaim(KEY_AUTH_TIME);
            return date == null ? null : date.toInstant();
        }
        catch (java.text.ParseException e) {
            this.log.error("Error parsing auth time {}", this.assertedClaimsSet().getClaim(KEY_AUTH_TIME));
            return null;
        }
    }

    @Nullable
    public Nonce getNonce() {
        Object nonce = this.assertedClaimsSet().getClaim(KEY_NONCE);
        return nonce == null ? null : new Nonce((String)nonce);
    }

    @Nullable
    public OIDCClaimsRequest getClaimsRequest() {
        JWTClaimsSet tokenClaimsSet = this.assertedClaimsSet();
        if (tokenClaimsSet.getClaim(KEY_CLAIMS) == null) {
            return null;
        }
        try {
            return OIDCClaimsRequest.parse((JSONObject)new JSONObject(tokenClaimsSet.getJSONObjectClaim(KEY_CLAIMS)));
        }
        catch (ParseException | java.text.ParseException e) {
            this.log.error("Error parsing claims request {}", tokenClaimsSet.getClaim(KEY_CLAIMS));
            return null;
        }
    }

    @Nullable
    public ClaimsSet getDeliveryClaims() {
        JWTClaimsSet tokenClaimsSet = this.assertedClaimsSet();
        ClaimsSet claimsSet = new ClaimsSet();
        try {
            Map claims = tokenClaimsSet.getJSONObjectClaim(KEY_DELIVERY_CLAIMS);
            if (claims == null) {
                return null;
            }
            claimsSet.putAll(claims);
        }
        catch (java.text.ParseException e) {
            this.log.error("Error parsing delivery claims {}", tokenClaimsSet.getClaim(KEY_DELIVERY_CLAIMS));
            return null;
        }
        return claimsSet;
    }

    @Nullable
    public ClaimsSet getIDTokenDeliveryClaims() {
        JWTClaimsSet tokenClaimsSet = this.assertedClaimsSet();
        ClaimsSet claimsSet = new ClaimsSet();
        try {
            Map claims = tokenClaimsSet.getJSONObjectClaim(KEY_DELIVERY_CLAIMS_IDTOKEN);
            if (claims == null) {
                return null;
            }
            claimsSet.putAll(claims);
        }
        catch (java.text.ParseException e) {
            this.log.error("Error parsing id token delivery claims {}", tokenClaimsSet.getClaim(KEY_DELIVERY_CLAIMS_IDTOKEN));
            return null;
        }
        return claimsSet;
    }

    @Nullable
    public ClaimsSet getUserinfoDeliveryClaims() {
        JWTClaimsSet tokenClaimsSet = this.assertedClaimsSet();
        ClaimsSet claimsSet = new ClaimsSet();
        try {
            Map claims = tokenClaimsSet.getJSONObjectClaim(KEY_DELIVERY_CLAIMS_USERINFO);
            if (claims == null) {
                return null;
            }
            claimsSet.putAll(claims);
        }
        catch (java.text.ParseException e) {
            this.log.error("Error parsing id token delivery claims {}", tokenClaimsSet.getClaim(KEY_DELIVERY_CLAIMS_USERINFO));
            return null;
        }
        return claimsSet;
    }

    @Nullable
    @NonnullElements
    public List<Object> getConsentedClaims() {
        return (List)this.assertedClaimsSet().getClaim(KEY_CONSENTED_CLAIMS);
    }

    public boolean isConsentEnabled() {
        JWTClaimsSet tokenClaimsSet = this.assertedClaimsSet();
        if (tokenClaimsSet.getClaim(KEY_CONSENT_ENABLED) != null) {
            try {
                return tokenClaimsSet.getBooleanClaim(KEY_CONSENT_ENABLED);
            }
            catch (java.text.ParseException e) {
                this.log.error("Error parsing scope in request {}", tokenClaimsSet.getClaim(KEY_CONSENT_ENABLED));
                return false;
            }
        }
        return tokenClaimsSet.getClaim(KEY_CONSENTED_CLAIMS) != null;
    }

    @Nullable
    public Scope getScope() {
        JWTClaimsSet tokenClaimsSet = this.assertedClaimsSet();
        try {
            return Scope.parse((String)tokenClaimsSet.getStringClaim(KEY_SCOPE));
        }
        catch (java.text.ParseException e) {
            this.log.error("Error parsing scope in request {}", tokenClaimsSet.getClaim(KEY_SCOPE));
            return null;
        }
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<String> getAudience() {
        return (List)Constraint.isNotNull((Object)this.assertedClaimsSet().getAudience(), (String)"The audience cannot be null");
    }

    @Nullable
    public String getCodeChallenge() {
        JWTClaimsSet tokenClaimsSet = this.assertedClaimsSet();
        if (tokenClaimsSet.getClaim(KEY_CODE_CHALLENGE) == null) {
            return null;
        }
        return (String)tokenClaimsSet.getClaim(KEY_CODE_CHALLENGE);
    }

    @Nullable
    public String getID() {
        return this.assertedClaimsSet().getJWTID();
    }

    @Nullable
    public ClientID getClientID() {
        JWTClaimsSet tokenClaimsSet = this.assertedClaimsSet();
        Object id = tokenClaimsSet.getClaim(KEY_CLIENTID);
        if (id == null) {
            id = tokenClaimsSet.getClaim(KEY_LEGACY_CLIENTID);
        }
        if (id instanceof String) {
            return new ClientID((String)id);
        }
        return null;
    }

    @Nullable
    public String getRootTokenIdentifier() {
        JWTClaimsSet tokenClaimsSet = this.assertedClaimsSet();
        if (tokenClaimsSet.getClaim(KEY_ROOT_JTI) == null) {
            return null;
        }
        return (String)tokenClaimsSet.getClaim(KEY_ROOT_JTI);
    }

    @Nullable
    public String getSessionIdentifier() {
        JWTClaimsSet tokenClaimsSet = this.assertedClaimsSet();
        if (tokenClaimsSet.getClaim(KEY_SESSION_ID) == null) {
            return null;
        }
        return (String)tokenClaimsSet.getClaim(KEY_SESSION_ID);
    }

    public static abstract class Builder<T extends TokenClaimsSet> {
        @Nullable
        protected String jwtid;
        @Nullable
        protected ClientID rpId;
        @Nullable
        @NotEmpty
        protected String iss;
        @Nullable
        @NotEmpty
        protected String principal;
        @Nullable
        @NotEmpty
        protected String sub;
        @Nullable
        protected ACR acr;
        @Nullable
        protected Instant iat;
        @Nullable
        protected Instant exp;
        @Nullable
        protected Instant nbt;
        @Nullable
        protected Instant authTime;
        @Nullable
        protected URI redirect;
        @Nullable
        protected Scope reqScope;
        @Nonnull
        @NonnullElements
        protected List<String> audience = CollectionSupport.emptyList();
        @Nullable
        protected Nonce nonce;
        @Nullable
        protected OIDCClaimsRequest reqClaims;
        @Nullable
        protected ClaimsSet dlClaims;
        @Nullable
        protected ClaimsSet dlClaimsID;
        @Nullable
        protected ClaimsSet dlClaimsUI;
        @Nullable
        protected List<Object> consentedClaims;
        @Nullable
        protected Boolean consentEnabled;
        @Nullable
        protected String codeChallenge;
        @Nonnull
        protected Map<String, Object> customClaims = new HashMap<String, Object>();
        @Nullable
        protected String rootTokenId;
        @Nullable
        protected String sessionId;

        protected Builder() {
        }

        @Nonnull
        protected JWTClaimsSet buildJWTClaimsSet(@Nonnull @NotEmpty String tokenType) {
            if (this.jwtid == null || this.rpId == null || this.iss == null || this.iat == null || this.exp == null || this.authTime == null || this.reqScope == null || this.sub == null) {
                throw new RuntimeException("Invalid parameters, programming error");
            }
            assert (this.rpId != null);
            String clientId = this.rpId.getValue();
            ACR ctxRef = this.acr;
            Nonce nonceValue = this.nonce;
            URI redirectUri = this.redirect;
            assert (this.reqScope != null);
            String scopeValue = this.reqScope.toString();
            OIDCClaimsRequest requestClaims = this.reqClaims;
            ClaimsSet deliveryClaims = this.dlClaims;
            ClaimsSet idTokenClaims = this.dlClaimsID;
            ClaimsSet userInfoClaims = this.dlClaimsUI;
            JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().claim(TokenClaimsSet.KEY_TYPE, (Object)tokenType).jwtID(this.jwtid).claim(TokenClaimsSet.KEY_CLIENTID, (Object)clientId).issuer(this.iss).subject(this.sub).claim(TokenClaimsSet.KEY_USER_PRINCIPAL, (Object)this.principal).claim(TokenClaimsSet.KEY_ACR, (Object)(ctxRef == null ? null : ctxRef.getValue())).issueTime(Date.from(this.iat)).expirationTime(Date.from(this.exp)).notBeforeTime(this.nbt != null ? Date.from(this.nbt) : null).audience(this.audience).claim(TokenClaimsSet.KEY_NONCE, (Object)(nonceValue == null ? null : nonceValue.getValue())).claim(TokenClaimsSet.KEY_AUTH_TIME, (Object)Date.from(this.authTime)).claim(TokenClaimsSet.KEY_REDIRECT_URI, (Object)(redirectUri == null ? null : redirectUri.toString())).claim(TokenClaimsSet.KEY_SCOPE, (Object)scopeValue).claim(TokenClaimsSet.KEY_CLAIMS, (Object)(requestClaims == null ? null : requestClaims.toJSONObject())).claim(TokenClaimsSet.KEY_DELIVERY_CLAIMS, (Object)(deliveryClaims == null ? null : deliveryClaims.toJSONObject())).claim(TokenClaimsSet.KEY_DELIVERY_CLAIMS_IDTOKEN, (Object)(idTokenClaims == null ? null : idTokenClaims.toJSONObject())).claim(TokenClaimsSet.KEY_DELIVERY_CLAIMS_USERINFO, (Object)(userInfoClaims == null ? null : userInfoClaims.toJSONObject())).claim(TokenClaimsSet.KEY_CONSENTED_CLAIMS, this.consentedClaims).claim(TokenClaimsSet.KEY_CODE_CHALLENGE, (Object)this.codeChallenge).claim(TokenClaimsSet.KEY_CONSENT_ENABLED, (Object)this.consentEnabled).claim(TokenClaimsSet.KEY_ROOT_JTI, (Object)this.rootTokenId).claim(TokenClaimsSet.KEY_SESSION_ID, (Object)this.sessionId);
            this.customClaims.forEach((n, v) -> {
                if (n != null) {
                    builder.claim(n, v);
                }
            });
            return (JWTClaimsSet)Constraint.isNotNull((Object)builder.build(), (String)"Could not build JWT claims set");
        }

        public Builder<T> setJWTID(@Nonnull IdentifierGenerationStrategy generator) {
            this.jwtid = ((IdentifierGenerationStrategy)Constraint.isNotNull((Object)generator, (String)"IdentifierGenerationStrategy cannot be null")).generateIdentifier();
            return this;
        }

        public Builder<T> setJWTID(@Nonnull IdentifierGenerationStrategy generator, boolean xmlSafe) {
            this.jwtid = ((IdentifierGenerationStrategy)Constraint.isNotNull((Object)generator, (String)"IdentifierGenerationStrategy cannot be null")).generateIdentifier(xmlSafe);
            return this;
        }

        public Builder<T> setJWTID(@Nonnull @NotEmpty String id) {
            this.jwtid = Constraint.isNotEmpty((String)id, (String)"JWT ID cannot be null");
            return this;
        }

        public Builder<T> setClientID(@Nonnull ClientID id) {
            this.rpId = id;
            return this;
        }

        public Builder<T> setIssuer(@Nonnull String s) {
            this.iss = Constraint.isNotEmpty((String)s, (String)"Issuer cannot be null or empty");
            return this;
        }

        public Builder<T> setPrincipal(@Nonnull String s) {
            this.principal = Constraint.isNotEmpty((String)s, (String)"Principal name cannot be null or empty");
            return this;
        }

        public Builder<T> setSubject(@Nonnull String s) {
            this.sub = Constraint.isNotEmpty((String)s, (String)"Subject name cannot be null or empty");
            return this;
        }

        public Builder<T> setIssuedAt(@Nonnull Instant i) {
            this.iat = (Instant)Constraint.isNotNull((Object)i, (String)"Issue time cannot be null");
            return this;
        }

        public Builder<T> setExpiresAt(@Nonnull Instant i) {
            this.exp = (Instant)Constraint.isNotNull((Object)i, (String)"Expiration time cannot be null");
            return this;
        }

        public Builder<T> setNotBefore(@Nullable Instant i) {
            this.nbt = i;
            return this;
        }

        public Builder<T> setRedirectURI(@Nonnull URI uri) {
            this.redirect = (URI)Constraint.isNotNull((Object)uri, (String)"Redirect URI cannot be null");
            return this;
        }

        public Builder<T> setScope(@Nonnull Scope s) {
            this.reqScope = (Scope)Constraint.isNotNull((Object)s, (String)"Scope cannot be null");
            return this;
        }

        public Builder<T> setAudience(@Nullable @NonnullElements Collection<String> aud) {
            this.audience = aud != null ? CollectionSupport.copyToList(aud) : CollectionSupport.emptyList();
            return this;
        }

        public Builder<T> setAuthenticationTime(@Nonnull Instant i) {
            this.authTime = (Instant)Constraint.isNotNull((Object)i, (String)"Authentication time cannot be null");
            return this;
        }

        public Builder<T> setACR(@Nullable ACR authenticationContextReference) {
            this.acr = authenticationContextReference;
            return this;
        }

        public Builder<T> setNonce(@Nullable Nonce requestNonce) {
            this.nonce = requestNonce;
            return this;
        }

        public Builder<T> setClaimsRequest(@Nullable OIDCClaimsRequest claimsRequest) {
            this.reqClaims = claimsRequest;
            return this;
        }

        public Builder<T> setDlClaims(@Nullable ClaimsSet claims) {
            this.dlClaims = claims;
            return this;
        }

        public Builder<T> setDlClaimsID(@Nullable ClaimsSet claims) {
            this.dlClaimsID = claims;
            return this;
        }

        public Builder<T> setDlClaimsUI(@Nullable ClaimsSet claims) {
            this.dlClaimsUI = claims;
            return this;
        }

        public Builder<T> setConsentedClaims(@Nullable List<Object> claims) {
            this.consentedClaims = claims;
            return this;
        }

        public Builder<T> setConsentEnabled(@Nullable Boolean flag) {
            this.consentEnabled = flag;
            return this;
        }

        public Builder<T> setCodeChallenge(@Nullable String challenge) {
            this.codeChallenge = challenge;
            return this;
        }

        public Builder<T> addCustomClaim(@Nonnull @NotEmpty String name, @Nullable Object value) {
            this.customClaims.put(name, value);
            return this;
        }

        public Builder<T> setCustomClaims(@Nonnull JSONObject claims) {
            claims.forEach((n, v) -> {
                if (n != null) {
                    this.customClaims.put((String)n, v);
                }
            });
            return this;
        }

        public Builder<T> setRootTokenIdentifier(@Nullable String id) {
            this.rootTokenId = id;
            return this;
        }

        public Builder<T> setSessionIdentifier(@Nullable String id) {
            this.sessionId = id;
            return this;
        }

        @Nonnull
        public abstract T build();
    }
}

