/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.audit.impl;

import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.OIDCAuthenticationResponseContextLookupFunction;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class AuthenticationContextReferenceAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, OIDCAuthenticationResponseContext> ctxLookupStrategy;

    public AuthenticationContextReferenceAuditExtractor() {
        this((Function<ProfileRequestContext, OIDCAuthenticationResponseContext>)new OIDCAuthenticationResponseContextLookupFunction());
    }

    public AuthenticationContextReferenceAuditExtractor(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseContext> strategy) {
        this.ctxLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDC authentication response context lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        ACR acr;
        OIDCAuthenticationResponseContext context = this.ctxLookupStrategy.apply(input);
        if (context != null && (acr = context.getAcr()) != null) {
            return acr.getValue();
        }
        return null;
    }
}

