/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.audit.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.text.ParseException;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.AbstractAuthenticationRequestLookupFunction;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AuthenticationRequestClaimsAuditExtractor
extends AbstractAuthenticationRequestLookupFunction<String>
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AuthenticationRequestClaimsAuditExtractor.class);
    @Nonnull
    @NotEmpty
    private final String key;

    public AuthenticationRequestClaimsAuditExtractor(@Nonnull @NotEmpty String claim) {
        this.key = claim;
    }

    protected String doLookup(@Nonnull AuthenticationRequest request) {
        JWT requestObject = this.getRequestObject();
        try {
            if (requestObject != null && requestObject.getJWTClaimsSet().getClaim(this.key) != null) {
                return requestObject.getJWTClaimsSet().getStringClaim(this.key);
            }
        }
        catch (ParseException e) {
            this.log.error("Unable to parse response mode from request object response_mode value");
            return null;
        }
        List value = (List)request.toParameters().get(this.key);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return (String)value.get(0);
    }
}

