/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.audit.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.OIDCRegistrationResponseContextLookupFunction;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class ClientIdRegistrationAuditExtractor
implements Function<ProfileRequestContext, String> {
    @Nonnull
    private final Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> ctxLookupStrategy;

    public ClientIdRegistrationAuditExtractor() {
        this((Function<ProfileRequestContext, OIDCClientRegistrationResponseContext>)new OIDCRegistrationResponseContextLookupFunction());
    }

    public ClientIdRegistrationAuditExtractor(Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> strategy) {
        this.ctxLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationResponseContext lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext input) {
        OIDCClientRegistrationResponseContext context = this.ctxLookupStrategy.apply(input);
        if (context != null) {
            return context.getClientId();
        }
        return null;
    }
}

