/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.decoding.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class RequestUtil {
    private RequestUtil() {
    }

    @Nullable
    public static String toString(@Nullable HTTPRequest httpReq) {
        Map parameters;
        if (httpReq == null) {
            return null;
        }
        String nl = System.lineSeparator();
        String ret = httpReq.getMethod().toString() + nl;
        Map headers = httpReq.getHeaderMap();
        if (headers != null) {
            ret = ret + "Headers:" + nl;
            for (Map.Entry entry : headers.entrySet()) {
                ret = ret + "\t" + (String)entry.getKey() + ":" + entry.getValue() + nl;
            }
        }
        if ((parameters = httpReq.getQueryParameters()) != null) {
            ret = ret + "Parameters:" + nl;
            for (Map.Entry entry : parameters.entrySet()) {
                ret = ret + "\t" + (String)entry.getKey() + ":" + (String)((List)entry.getValue()).get(0) + nl;
            }
        }
        return ret;
    }

    @Nullable
    public static String toString(@Nullable HTTPRequest httpReq, @Nullable ObjectMapper objectMapper) {
        Map parameters;
        if (httpReq == null) {
            return null;
        }
        String nl = System.lineSeparator();
        String ret = httpReq.getMethod().toString() + nl;
        Map headers = httpReq.getHeaderMap();
        if (headers != null) {
            ret = ret + "Headers:" + nl;
            for (Map.Entry entry : headers.entrySet()) {
                ret = ret + "\t" + (String)entry.getKey() + ":" + entry.getValue() + nl;
            }
        }
        if ((parameters = httpReq.getQueryParameters()) != null) {
            if (objectMapper != null && !parameters.isEmpty()) {
                String rawValue = (String)parameters.keySet().iterator().next();
                try {
                    Object jsonObject = objectMapper.readValue(rawValue, Object.class);
                    String content = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
                    return ret + "Content:" + content.replace("\n", "\n\t");
                }
                catch (JsonProcessingException jsonObject) {
                    // empty catch block
                }
            }
            ret = ret + "Parameters:" + nl;
            for (Map.Entry entry : parameters.entrySet()) {
                ret = ret + "\t" + (String)entry.getKey() + ":" + (String)((List)entry.getValue()).get(0) + nl;
            }
        }
        return ret;
    }

    @Nullable
    public static String getClientAuthenticationLog(@Nullable ClientAuthentication authentication) {
        return authentication == null ? null : MoreObjects.toStringHelper((String)"ClientAuthentication").omitNullValues().add("clientId", (Object)authentication.getClientID()).add("method", (Object)authentication.getMethod()).toString();
    }

    @Nullable
    public static String getAccessTokenLog(@Nullable AccessToken accessToken) {
        return accessToken == null ? null : MoreObjects.toStringHelper((String)"AccessToken").omitNullValues().add("lifetime", accessToken.getLifetime()).add("issuedTokenType", (Object)accessToken.getIssuedTokenType()).add("parameterNames", (Object)accessToken.getParameterNames()).add("scope", (Object)accessToken.getScope()).add("value", (Object)accessToken.getValue()).add("type", (Object)accessToken.getType()).toString();
    }

    @Nullable
    public static String getAuthorizationGrantLog(@Nullable AuthorizationGrant grant) {
        if (grant == null) {
            return null;
        }
        if (grant instanceof AuthorizationCodeGrant) {
            AuthorizationCodeGrant codeGrant = (AuthorizationCodeGrant)grant;
            return MoreObjects.toStringHelper((Object)codeGrant).omitNullValues().add("authorizationCode", (Object)codeGrant.getAuthorizationCode()).add("codeVerifier", (Object)codeGrant.getCodeVerifier()).add("redirectionURI", (Object)codeGrant.getRedirectionURI()).add("type", (Object)codeGrant.getType()).toString();
        }
        if (grant instanceof RefreshTokenGrant) {
            RefreshTokenGrant refreshGrant = (RefreshTokenGrant)grant;
            return MoreObjects.toStringHelper((Object)refreshGrant).omitNullValues().add("refreshToken", (Object)RequestUtil.getRefreshTokenLog(refreshGrant.getRefreshToken())).add("type", (Object)refreshGrant.getType()).toString();
        }
        if (grant instanceof ClientCredentialsGrant) {
            ClientCredentialsGrant credentialsGrant = (ClientCredentialsGrant)grant;
            return MoreObjects.toStringHelper((Object)credentialsGrant).omitNullValues().add("type", (Object)credentialsGrant.getType()).toString();
        }
        return MoreObjects.toStringHelper((Object)grant).omitNullValues().add("type", (Object)grant.getType()).toString();
    }

    @Nullable
    public static String getRefreshTokenLog(@Nullable RefreshToken refreshToken) {
        return refreshToken == null ? null : MoreObjects.toStringHelper((String)"RefreshToken").omitNullValues().add("parameterNames", (Object)refreshToken.getParameterNames()).add("value", (Object)refreshToken.getValue()).toString();
    }
}

