/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.encoding.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.http.JakartaServletUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.encoding.impl.ResponseUtil;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.HTMLEncoder;
import net.shibboleth.shared.codec.StringDigester;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import net.shibboleth.shared.servlet.HttpServletSupport;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.encoder.servlet.AbstractHttpServletResponseMessageEncoder;

public class NimbusResponseEncoder
extends AbstractHttpServletResponseMessageEncoder {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_TEMPLATE_ID = "/templates/oidc-form-post.vm";
    @Nullable
    private VelocityEngine velocityEngine;
    @Nonnull
    @NotEmpty
    private String velocityTemplateId = "/templates/oidc-form-post.vm";
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @Nullable
    private StringDigester cspDigester;
    @Nullable
    private IdentifierGenerationStrategy cspNonceGenerator;

    public NimbusResponseEncoder() {
        this.setProtocolMessageLoggerSubCategory("OAUTH2");
    }

    public void setVelocityTemplateId(String newVelocityTemplateId) {
        this.checkSetterPreconditions();
        this.velocityTemplateId = Constraint.isNotEmpty((String)newVelocityTemplateId, (String)"Velocity template id must not not be null or empty");
    }

    public void setVelocityEngine(VelocityEngine newVelocityEngine) {
        this.checkSetterPreconditions();
        this.velocityEngine = newVelocityEngine;
    }

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }

    public void setCSPDigester(@Nullable StringDigester digester) {
        this.checkSetterPreconditions();
        this.cspDigester = digester;
    }

    public void setCSPNonceGenerator(@Nullable IdentifierGenerationStrategy strategy) {
        this.checkSetterPreconditions();
        this.cspNonceGenerator = strategy;
    }

    private boolean impliesFormPost(@Nullable Object response) {
        return response instanceof AuthorizationResponse && ResponseMode.FORM_POST.equals((Object)((AuthorizationResponse)response).getResponseMode());
    }

    private VelocityContext doPostEncode(@Nonnull AuthorizationResponse message) {
        VelocityContext context = new VelocityContext();
        for (Map.Entry entry : message.toParameters().entrySet()) {
            context.put((String)entry.getKey(), ((List)entry.getValue()).get(0));
        }
        context.put("action", (Object)HTMLEncoder.encodeForHTMLAttribute((String)message.getRedirectionURI().toString()));
        if (this.cspDigester != null) {
            context.put("cspDigester", (Object)this.cspDigester);
        }
        if (this.cspNonceGenerator != null) {
            context.put("cspNonce", (Object)this.cspNonceGenerator);
        }
        context.put("response", (Object)this.getHttpServletResponse());
        return context;
    }

    protected void doEncode() throws MessageEncodingException {
        Object message = this.getMessageContext().getMessage();
        if (!(message instanceof Response)) {
            throw new MessageEncodingException("Incorrect message type");
        }
        try {
            HttpServletResponse response = this.getHttpServletResponse();
            assert (response != null);
            if (this.impliesFormPost(message) && message instanceof AuthorizationResponse) {
                AuthorizationResponse authzResponse = (AuthorizationResponse)message;
                VelocityEngine engine = this.velocityEngine;
                if (engine == null) {
                    throw new MessageEncodingException("VelocityEngine must be supplied for form post response mode");
                }
                VelocityContext context = this.doPostEncode(authzResponse);
                HttpServletSupport.addNoCacheHeaders((HttpServletResponse)response);
                HttpServletSupport.setUTF8Encoding((HttpServletResponse)response);
                HttpServletSupport.setContentType((HttpServletResponse)response, (String)"text/html");
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
                engine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, (Writer)out);
                ((Writer)out).flush();
                ((Writer)out).close();
                StringWriter writer = new StringWriter();
                engine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, (Writer)writer);
                this.getProtocolMessageLogger().trace("Outbound response {}", (Object)ResponseUtil.toString(response, writer.toString()));
                return;
            }
            HTTPResponse resp = ((Response)message).toHTTPResponse();
            this.getProtocolMessageLogger().trace("Outbound response {}", (Object)ResponseUtil.toString(resp, this.objectMapper));
            JakartaServletUtils.applyHTTPResponse((HTTPResponse)resp, (HttpServletResponse)response);
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem encoding response", (Exception)e);
        }
    }

    @Nullable
    protected String serializeMessageForLogging(@Nullable Object message) {
        return ResponseUtil.getProtocolMessage((Response)message);
    }
}

