/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.encoding.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationErrorResponse;
import com.nimbusds.oauth2.sdk.AuthorizationResponse;
import com.nimbusds.oauth2.sdk.AuthorizationSuccessResponse;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ErrorResponse;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenIntrospectionErrorResponse;
import com.nimbusds.oauth2.sdk.TokenIntrospectionResponse;
import com.nimbusds.oauth2.sdk.TokenIntrospectionSuccessResponse;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.client.ClientInformation;
import com.nimbusds.oauth2.sdk.client.ClientInformationResponse;
import com.nimbusds.oauth2.sdk.client.ClientRegistrationErrorResponse;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.LogoutTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformationResponse;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import jakarta.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.RequestUtil;
import net.shibboleth.idp.plugin.oidc.op.messaging.JSONSuccessResponse;
import net.shibboleth.idp.plugin.oidc.op.oauth2.messaging.impl.OAuth2RevocationErrorResponse;
import net.shibboleth.idp.plugin.oidc.op.oauth2.messaging.impl.OAuth2RevocationSuccessResponse;

public final class ResponseUtil {
    private ResponseUtil() {
    }

    protected static String toString(@Nullable HTTPResponse httpResponse) {
        return ResponseUtil.toString(httpResponse, null);
    }

    protected static String toString(@Nullable HTTPResponse httpResponse, @Nullable ObjectMapper objectMapper) {
        String rawContent;
        if (httpResponse == null) {
            return null;
        }
        String nl = System.lineSeparator();
        Object ret = nl;
        Map headers = httpResponse.getHeaderMap();
        if (headers != null) {
            ret = (String)ret + "Headers:" + nl;
            for (Map.Entry entry : headers.entrySet()) {
                ret = (String)ret + "\t" + (String)entry.getKey() + ":" + (String)((List)entry.getValue()).get(0) + nl;
            }
        }
        if ((rawContent = httpResponse.getContent()) != null) {
            if (objectMapper != null) {
                try {
                    Object jsonObject = objectMapper.readValue(rawContent, Object.class);
                    String content = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
                    ret = (String)ret + "Content:" + content.replace("\n", "\n\t");
                    return ret;
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
            ret = (String)ret + "Content:" + rawContent;
        }
        return ret;
    }

    @Nullable
    protected static String toString(@Nullable HttpServletResponse httpServletResponse, @Nullable String content) {
        if (httpServletResponse == null) {
            return null;
        }
        String nl = System.lineSeparator();
        Object ret = nl;
        Collection headerNames = httpServletResponse.getHeaderNames();
        if (headerNames != null) {
            ret = (String)ret + "Headers:" + nl;
            for (String headerName : headerNames) {
                ret = (String)ret + "\t" + headerName + ":" + httpServletResponse.getHeader(headerName) + nl;
            }
        }
        if (content != null) {
            ret = (String)ret + "Content:" + content;
        }
        return ret;
    }

    @Nullable
    public static String getProtocolMessage(@Nullable Response response) {
        if (response == null) {
            return null;
        }
        if (response instanceof AuthenticationResponse) {
            return ResponseUtil.getProtocolMessageForAuthenticationResponse((AuthenticationResponse)response);
        }
        if (response instanceof AuthorizationResponse) {
            return ResponseUtil.getProtocolMessageForAuthorizationResponse((AuthorizationResponse)response);
        }
        if (response instanceof OIDCClientInformationResponse) {
            return ResponseUtil.getProtocolMessageForRegistrationResponse((OIDCClientInformationResponse)response);
        }
        if (response instanceof TokenResponse) {
            return ResponseUtil.getProtocolMessageForTokenResponse((TokenResponse)response);
        }
        if (response instanceof UserInfoResponse) {
            return ResponseUtil.getProtocolMessageForUserInfoResponse((UserInfoResponse)response);
        }
        if (response instanceof TokenIntrospectionResponse) {
            return ResponseUtil.getProtocolMessageForIntrospectionResponse((TokenIntrospectionResponse)response);
        }
        if (response instanceof OAuth2RevocationSuccessResponse) {
            return ResponseUtil.getProtocolMessageForRevocationResponse(response);
        }
        if (response instanceof OAuth2RevocationErrorResponse) {
            return ResponseUtil.getProtocolMessageForRevocationResponse(response);
        }
        if (response instanceof JSONSuccessResponse) {
            return ResponseUtil.getProtocolMessageForJSONSuccessResponse(response);
        }
        if (response instanceof ErrorResponse) {
            ErrorResponse genericError = (ErrorResponse)response;
            return MoreObjects.toStringHelper((Object)genericError).omitNullValues().add("errorObject", (Object)genericError.getErrorObject()).toString();
        }
        return MoreObjects.toStringHelper((Object)response).toString();
    }

    @Nullable
    public static String getProtocolMessageForAuthenticationResponse(@Nonnull AuthenticationResponse response) {
        if (response.indicatesSuccess()) {
            AuthenticationSuccessResponse successResponse = response.toSuccessResponse();
            return MoreObjects.toStringHelper((Object)successResponse).omitNullValues().add("accessToken", (Object)RequestUtil.getAccessTokenLog(successResponse.getAccessToken())).add("authorizationCode", (Object)successResponse.getAuthorizationCode()).add("idToken", successResponse.getIDToken() == null ? null : successResponse.getIDToken().serialize()).add("issuer", (Object)successResponse.getIssuer()).add("jwtResponse", successResponse.getJWTResponse() == null ? null : successResponse.getJWTResponse().serialize()).add("redirectionURI", (Object)successResponse.getRedirectionURI()).add("responseMode", (Object)successResponse.getResponseMode()).add("sessionState", (Object)successResponse.getSessionState()).add("state", (Object)successResponse.getState()).toString();
        }
        AuthenticationErrorResponse errorResponse = response.toErrorResponse();
        return MoreObjects.toStringHelper((Object)errorResponse).omitNullValues().add("errorObject", (Object)ResponseUtil.getProtocolMessageForErrorObject(errorResponse.getErrorObject())).add("issuer", (Object)errorResponse.getIssuer()).add("jwtResponse", errorResponse.getJWTResponse() == null ? null : errorResponse.getJWTResponse().serialize()).add("redirectionURI", (Object)errorResponse.getRedirectionURI()).add("responseMode", (Object)errorResponse.getResponseMode()).add("state", (Object)errorResponse.getState()).toString();
    }

    @Nullable
    public static String getProtocolMessageForAuthorizationResponse(@Nonnull AuthorizationResponse response) {
        if (response.indicatesSuccess()) {
            AuthorizationSuccessResponse successResponse = response.toSuccessResponse();
            return MoreObjects.toStringHelper((Object)successResponse).omitNullValues().add("accessToken", (Object)RequestUtil.getAccessTokenLog(successResponse.getAccessToken())).add("authorizationCode", (Object)successResponse.getAuthorizationCode()).add("issuer", (Object)successResponse.getIssuer()).add("jwtResponse", successResponse.getJWTResponse() == null ? null : successResponse.getJWTResponse().serialize()).add("redirectionURI", (Object)successResponse.getRedirectionURI()).add("responseMode", (Object)successResponse.getResponseMode()).add("state", (Object)successResponse.getState()).toString();
        }
        AuthorizationErrorResponse errorResponse = response.toErrorResponse();
        return MoreObjects.toStringHelper((Object)errorResponse).omitNullValues().add("errorObject", (Object)ResponseUtil.getProtocolMessageForErrorObject(errorResponse.getErrorObject())).add("issuer", (Object)errorResponse.getIssuer()).add("jwtResponse", errorResponse.getJWTResponse() == null ? null : errorResponse.getJWTResponse().serialize()).add("redirectionURI", (Object)errorResponse.getRedirectionURI()).add("responseMode", (Object)errorResponse.getResponseMode()).add("state", (Object)errorResponse.getState()).toString();
    }

    @Nullable
    public static String getProtocolMessageForRegistrationResponse(@Nonnull OIDCClientInformationResponse response) {
        if (response.indicatesSuccess()) {
            ClientInformationResponse successResponse = response.toSuccessResponse();
            return MoreObjects.toStringHelper((Object)successResponse).omitNullValues().add("clientInformation", (Object)ResponseUtil.getProtocolMessageForClientInformation(successResponse.getClientInformation())).toString();
        }
        ClientRegistrationErrorResponse errorResponse = response.toErrorResponse();
        return MoreObjects.toStringHelper((Object)errorResponse).omitNullValues().add("errorObject", (Object)ResponseUtil.getProtocolMessageForErrorObject(errorResponse.getErrorObject())).toString();
    }

    @Nullable
    public static String getProtocolMessageForClientInformation(@Nullable ClientInformation clientInformation) {
        return clientInformation == null ? null : MoreObjects.toStringHelper((Object)clientInformation).omitNullValues().add("clientId", (Object)clientInformation.getID()).add("idIssuedDate", (Object)clientInformation.getIDIssueDate()).add("metadadata", (Object)clientInformation.getMetadata()).add("registrationAccessToken", (Object)RequestUtil.getAccessTokenLog((AccessToken)clientInformation.getRegistrationAccessToken())).add("registrationURI", (Object)clientInformation.getRegistrationURI()).add("secret", (Object)(clientInformation.getSecret() == null ? null : "<secret>")).toString();
    }

    @Nullable
    public static String getProtocolMessageForTokenResponse(@Nonnull TokenResponse response) {
        if (response.indicatesSuccess()) {
            AccessTokenResponse successResponse = response.toSuccessResponse();
            return MoreObjects.toStringHelper((Object)successResponse).omitNullValues().add("customParameters", (Object)successResponse.getCustomParameters()).add("tokens", (Object)successResponse.getTokens()).toString();
        }
        TokenErrorResponse errorResponse = response.toErrorResponse();
        return MoreObjects.toStringHelper((Object)errorResponse).omitNullValues().add("errorObject", (Object)ResponseUtil.getProtocolMessageForErrorObject(errorResponse.getErrorObject())).toString();
    }

    @Nullable
    public static String getProtocolMessageForErrorObject(@Nullable ErrorObject errorObject) {
        return errorObject == null ? null : MoreObjects.toStringHelper((Object)errorObject).omitNullValues().add("httpStatusCode", errorObject.getHTTPStatusCode()).add("code", (Object)errorObject.getCode()).add("description", (Object)errorObject.getDescription()).add("uri", (Object)errorObject.getURI()).toString();
    }

    @Nullable
    public static String getProtocolMessageForTokens(@Nullable Tokens tokens) {
        String idToken = tokens instanceof OIDCTokens ? MoreObjects.toStringHelper(OIDCTokens.class).omitNullValues().add("idToken", tokens.toOIDCTokens().getIDToken() == null ? null : tokens.toOIDCTokens().getIDToken().serialize()).toString() : null;
        return tokens == null ? null : MoreObjects.toStringHelper((Object)tokens).omitNullValues().add("accessToken", (Object)tokens.getAccessToken()).add("metadata", (Object)tokens.getMetadata()).add("parameterNames", (Object)tokens.getParameterNames()).add("refreshToken", (Object)tokens.getRefreshToken()).add("idToken", (Object)idToken).toString();
    }

    @Nullable
    public static String getProtocolMessageForUserInfoResponse(@Nonnull UserInfoResponse response) {
        if (response.indicatesSuccess()) {
            UserInfoSuccessResponse successResponse = response.toSuccessResponse();
            return MoreObjects.toStringHelper((Object)successResponse).omitNullValues().add("entityContentType", (Object)successResponse.getEntityContentType()).add("userInfo", successResponse.getUserInfo() != null ? successResponse.getUserInfo().toJSONString() : null).add("userInfoJWT", successResponse.getUserInfoJWT() == null ? null : successResponse.getUserInfoJWT().serialize()).toString();
        }
        UserInfoErrorResponse errorResponse = response.toErrorResponse();
        return MoreObjects.toStringHelper((Object)errorResponse).omitNullValues().add("errorObject", (Object)errorResponse.getErrorObject()).toString();
    }

    @Nullable
    public static String getProtocolMessageForIntrospectionResponse(@Nonnull TokenIntrospectionResponse response) {
        if (response.indicatesSuccess()) {
            TokenIntrospectionSuccessResponse successResponse = response.toSuccessResponse();
            return MoreObjects.toStringHelper((Object)successResponse).omitNullValues().add("active", successResponse.isActive()).add("audience", (Object)successResponse.getAudience()).add("clientId", (Object)successResponse.getClientID()).add("expirationTime", (Object)successResponse.getExpirationTime()).add("issuer", (Object)successResponse.getIssuer()).add("issueTime", (Object)successResponse.getIssueTime()).add("jwtId", (Object)successResponse.getJWTID()).add("notBeforeTime", (Object)successResponse.getNotBeforeTime()).add("parameters", (Object)successResponse.getParameters()).add("scope", (Object)successResponse.getScope()).add("jwkThumbprintConfirmation", (Object)successResponse.getJWKThumbprintConfirmation()).add("subject", (Object)successResponse.getSubject()).add("tokenType", (Object)successResponse.getTokenType()).add("username", (Object)successResponse.getUsername()).toString();
        }
        TokenIntrospectionErrorResponse errorResponse = response.toErrorResponse();
        return MoreObjects.toStringHelper((Object)errorResponse).omitNullValues().add("errorObject", (Object)errorResponse.getErrorObject()).toString();
    }

    @Nullable
    public static String getProtocolMessageForRevocationResponse(@Nonnull Response response) {
        if (response instanceof OAuth2RevocationSuccessResponse) {
            OAuth2RevocationSuccessResponse successResponse = (OAuth2RevocationSuccessResponse)response;
            return MoreObjects.toStringHelper((Object)successResponse).omitNullValues().toString();
        }
        if (response instanceof OAuth2RevocationErrorResponse) {
            OAuth2RevocationErrorResponse errorResponse = (OAuth2RevocationErrorResponse)response;
            return MoreObjects.toStringHelper((Object)errorResponse).omitNullValues().add("errorObject", (Object)errorResponse.getErrorObject()).toString();
        }
        return null;
    }

    @Nullable
    public static String getProtocolMessageForJSONSuccessResponse(@Nonnull Response response) {
        if (response instanceof JSONSuccessResponse) {
            JSONSuccessResponse successResponse = (JSONSuccessResponse)response;
            return successResponse.toString();
        }
        return null;
    }

    @Nonnull
    public static String getJwtProtocolMessage(@Nonnull JWT jwt, @Nonnull ObjectMapper objectMapper) throws ParseException {
        return ResponseUtil.getJwtProtocolMessage(jwt.getJWTClaimsSet(), objectMapper);
    }

    @Nonnull
    public static String getIdTokenProtocolMessage(@Nonnull IDTokenClaimsSet idToken, @Nonnull ObjectMapper objectMapper) throws ParseException {
        try {
            return ResponseUtil.getJwtProtocolMessage(idToken.toJWTClaimsSet(), objectMapper);
        }
        catch (com.nimbusds.oauth2.sdk.ParseException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ParseException) {
                ParseException parseException = (ParseException)cause;
                throw parseException;
            }
            throw new ParseException(e.getMessage(), 0);
        }
    }

    @Nonnull
    public static String getLogoutTokenProtocolMessage(@Nonnull LogoutTokenClaimsSet logoutToken, @Nonnull ObjectMapper objectMapper) throws ParseException {
        try {
            return ResponseUtil.getJwtProtocolMessage(logoutToken.toJWTClaimsSet(), objectMapper);
        }
        catch (com.nimbusds.oauth2.sdk.ParseException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ParseException) {
                ParseException parseException = (ParseException)cause;
                throw parseException;
            }
            throw new ParseException(e.getMessage(), 0);
        }
    }

    @Nonnull
    public static String getJwtProtocolMessage(@Nullable JWTClaimsSet claimsSet, @Nonnull ObjectMapper objectMapper) throws ParseException {
        if (claimsSet == null) {
            return "<encrypted>";
        }
        try {
            Object jsonObject = objectMapper.readValue(claimsSet.toString(), Object.class);
            String content = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
            if (content != null) {
                return content;
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        throw new ParseException("Could not parse the JSON output from the claims set", 0);
    }
}

