/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.logout.profile.impl;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.jwt.JWT;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.logout.profile.impl.AbstractOIDCBackChannelLogoutPropagationAction;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCLogoutPropagationContext;
import net.shibboleth.idp.plugin.oidc.op.session.OIDCRPSession;
import net.shibboleth.idp.session.context.LogoutPropagationContext;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.profile.config.navigate.ClientInformationStringValueLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;

public class ExecuteBackChannelLogoutRequest
extends AbstractOIDCBackChannelLogoutPropagationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExecuteBackChannelLogoutRequest.class);
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;
    @Nonnull
    private final Function<OIDCClientInformation, String> oidcBackChannelLogoutURILookupFunction = new ClientInformationStringValueLookupFunction("backchannel_logout_uri");
    @Nullable
    private URI backChannelLogoutURI;
    @Nullable
    private JWT logoutToken;

    public void setHttpClient(@Nonnull HttpClient client) {
        this.checkSetterPreconditions();
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.checkSetterPreconditions();
        this.httpClientSecurityParameters = params;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        Constraint.isNotNull((Object)this.httpClient, (String)"Httpclient cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getMetadataContext() == null) {
            this.log.error("{} No OIDC metadata context available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        OIDCMetadataContext metadataContext = this.getMetadataContext();
        assert (metadataContext != null);
        String backChannelLogoutURIValue = this.oidcBackChannelLogoutURILookupFunction.apply(metadataContext.getClientInformation());
        if (backChannelLogoutURIValue == null) {
            this.log.error("{} Back-channel logout URI cannot be determined.", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        try {
            this.backChannelLogoutURI = new URI(backChannelLogoutURIValue);
        }
        catch (URISyntaxException e) {
            this.log.error("{} Could not build an URI of the back-channel logout URI value {}", (Object)this.getLogPrefix(), (Object)backChannelLogoutURIValue);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        OIDCAuthenticationResponseContext oidcResponseContext = this.getOidcResponseContext();
        assert (oidcResponseContext != null);
        this.logoutToken = oidcResponseContext.getProcessedToken();
        if (this.logoutToken == null) {
            this.log.error("{} OIDCAuthenticationResponseContext did not contain any back-channel logout token.", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCRPSession rpSession = this.getOidcRPSession();
        assert (rpSession != null);
        String relyingPartyId = rpSession.getId();
        String subject = rpSession.getSubject();
        String sessionId = rpSession.getSessionIdentifier();
        HttpPost httpRequest = new HttpPost(this.backChannelLogoutURI);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        assert (this.logoutToken != null);
        String serializedToken = this.logoutToken.serialize();
        nvps.add(new BasicNameValuePair("logout_token", serializedToken));
        this.log.trace("{} Logout token to be used in the request: {}", (Object)this.getLogPrefix(), (Object)serializedToken);
        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8);
        httpRequest.setEntity((HttpEntity)urlEncodedFormEntity);
        httpRequest.setHeader("Content-Type", (Object)ContentType.APPLICATION_URLENCODED.getType());
        HttpClientContext httpContext = this.buildHttpContext((HttpUriRequest)httpRequest);
        this.log.debug("{} Sending the back-channel logout request to {}", (Object)this.getLogPrefix(), (Object)this.backChannelLogoutURI);
        LogoutPropagationContext logoutPropContext = this.getLogoutPropagationContext();
        assert (logoutPropContext != null);
        try (ClassicHttpResponse response = this.httpClient.executeOpen(null, (ClassicHttpRequest)httpRequest, (HttpContext)httpContext);){
            String scheme = httpRequest.getUri().getScheme();
            assert (scheme != null);
            HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)httpContext, (String)scheme);
            OIDCLogoutPropagationContext oidcLogouPropContext = this.getOidcLogoutContext();
            assert (oidcLogouPropContext != null);
            if (response.getCode() == 200 || response.getCode() == 204) {
                if (!oidcLogouPropContext.hasRevocationError()) {
                    logoutPropContext.setResult(LogoutPropagationContext.Result.Success);
                    this.log.debug("{} back-channel logout for rp '{}', sub '{}' and sid '{}' succeeded.", new Object[]{this.getLogPrefix(), relyingPartyId, subject, sessionId});
                } else {
                    logoutPropContext.setResult(LogoutPropagationContext.Result.Failure);
                    this.log.debug("{} back-channel logout for rp '{}', sub '{}' and sid '{}' succeeded, but overall result remains 'failure' due to previous error", new Object[]{this.getLogPrefix(), relyingPartyId, subject, sessionId});
                }
            } else {
                logoutPropContext.setResult(LogoutPropagationContext.Result.Failure);
                this.log.error("{} back-channel logout for rp '{}', sub '{}' and sid '{}' failed. HTTP code: {}", new Object[]{this.getLogPrefix(), relyingPartyId, subject, sessionId, response.getCode()});
            }
        }
        catch (IOException | URISyntaxException e) {
            this.log.error("{} back-channel logout for rp '{}' with token '{}' failed.", new Object[]{this.getLogPrefix(), relyingPartyId, serializedToken, e});
            logoutPropContext.setResult(LogoutPropagationContext.Result.Failure);
        }
    }

    @Nonnull
    private HttpClientContext buildHttpContext(@Nonnull HttpUriRequest request) {
        HttpClientContext clientContext = HttpClientContext.create();
        assert (clientContext != null);
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)this.httpClientSecurityParameters, (boolean)false);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpRequest)request);
        return clientContext;
    }
}

