/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.MetadataValueResolver;
import net.shibboleth.oidc.profile.config.JSONSecurityConfiguration;
import net.shibboleth.oidc.security.jose.EncryptionConfiguration;
import net.shibboleth.oidc.security.jose.SignatureSigningConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.config.SecurityConfiguration;
import org.opensaml.xmlsec.AlgorithmPolicyConfiguration;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.slf4j.Logger;

public class AlgorithmInfoMetadataValueResolver
extends AbstractIdentifiableInitializableComponent
implements MetadataValueResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AlgorithmInfoMetadataValueResolver.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    private boolean resolveEncryptionAlgs;
    private boolean resolveKeyTransportEncAlgs;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setResolveEncryptionAlgs(boolean flag) {
        this.resolveEncryptionAlgs = flag;
    }

    public void setResolveKeyTransportEncAlgs(boolean flag) {
        this.resolveKeyTransportEncAlgs = flag;
    }

    public Iterable<Object> resolve(ProfileRequestContext profileRequestContext) throws ResolverException {
        ArrayList<Object> result = new ArrayList<Object>();
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpCtx == null || rpCtx.getProfileConfig() == null) {
            this.log.warn("Could not find profile configuration, nothing to do");
            return result;
        }
        ProfileConfiguration profileConfig = rpCtx.getProfileConfig();
        assert (profileConfig != null);
        SecurityConfiguration securityConfig = profileConfig.getSecurityConfiguration(profileRequestContext);
        if (securityConfig == null) {
            this.log.warn("Could not find security configuration, nothing to do");
            return result;
        }
        if (!(securityConfig instanceof JSONSecurityConfiguration)) {
            this.log.warn("Security configuration class was not expected: {}", (Object)securityConfig);
            return result;
        }
        JSONSecurityConfiguration jsonSecurityConfig = (JSONSecurityConfiguration)securityConfig;
        ArrayList<String> algorithms = new ArrayList<String>();
        if (this.resolveEncryptionAlgs) {
            EncryptionConfiguration encryptionConfig = jsonSecurityConfig.getJwtEncryptionConfiguration();
            if (encryptionConfig != null) {
                if (this.resolveKeyTransportEncAlgs) {
                    this.populateAlgorithmsAgainstPolicy(algorithms, encryptionConfig.getKeyTransportEncryptionAlgorithms(), (AlgorithmPolicyConfiguration)encryptionConfig);
                } else {
                    this.populateAlgorithmsAgainstPolicy(algorithms, encryptionConfig.getDataEncryptionAlgorithms(), (AlgorithmPolicyConfiguration)encryptionConfig);
                }
            }
        } else {
            SignatureSigningConfiguration signingConfig = jsonSecurityConfig.getJwtSignatureSigningConfiguration();
            if (signingConfig != null) {
                this.populateAlgorithmsAgainstPolicy(algorithms, signingConfig.getSignatureAlgorithms(), (AlgorithmPolicyConfiguration)signingConfig);
            }
        }
        result.add(algorithms);
        return result;
    }

    protected void populateAlgorithmsAgainstPolicy(List<String> algorithms, List<String> candidates, AlgorithmPolicyConfiguration policy) {
        for (String candidate : candidates) {
            if (candidate != null && !AlgorithmSupport.validateAlgorithmURI((String)candidate, (Collection)policy.getIncludedAlgorithms(), (Collection)policy.getExcludedAlgorithms())) {
                this.log.debug("Algorithm failed include/exclude validation: {}", (Object)candidate);
                continue;
            }
            algorithms.add(candidate);
        }
    }

    public Object resolveSingle(@Nullable ProfileRequestContext profileRequestContext) throws ResolverException {
        Iterator<Object> iterator = this.resolve(profileRequestContext).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

