/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.metadata.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Identifier;
import java.io.IOException;
import java.util.List;
import java.util.Timer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONValue;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.RefreshableMetadataValueResolver;
import net.shibboleth.oidc.metadata.impl.AbstractFileOIDCEntityResolver;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.core.io.Resource;

public class FilesystemMetadataValueResolver
extends AbstractFileOIDCEntityResolver<Identifier, Object>
implements RefreshableMetadataValueResolver {
    public FilesystemMetadataValueResolver(@Nonnull Resource metadata) throws IOException {
        super(metadata);
    }

    public FilesystemMetadataValueResolver(@Nullable Timer backgroundTaskTimer, @Nonnull Resource metadata) throws IOException {
        super(backgroundTaskTimer, metadata);
    }

    @Nonnull
    public Iterable<Object> resolve(@Nullable ProfileRequestContext profileRequestContext) throws ResolverException {
        this.ifNotInitializedThrowUninitializedComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        return this.getBackingStore().getOrderedInformation();
    }

    @Nullable
    public Object resolveSingle(@Nullable ProfileRequestContext profileRequestContext) throws ResolverException {
        return this.resolve(profileRequestContext).iterator().next();
    }

    @Nonnull
    protected List<Object> parse(byte[] bytes) throws ParseException {
        Object json = JSONValue.parse((byte[])bytes);
        if (json == null) {
            throw new ParseException("Could not parse JSON object from the bytes");
        }
        return CollectionSupport.listOf((Object)json);
    }

    protected Identifier getKey(Object value) {
        return new Identifier("dynamic metadata value");
    }
}

